<?php
session_start();
header('Content-Type: application/json');
// تأكد من أن المسارات هذه صحيحة بعد نقل الملف للمجلد الرئيسي
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

$response = ['success' => false, 'message' => 'حدث خطأ غير متوقع'];

try {
    // التحقق من تسجيل الدخول
    if (!isset($_SESSION['user_id'])) {
        $response['message'] = 'غير مسموح بالوصول';
        echo json_encode($response);
        exit();
    }

    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    // إذا لم تكن البيانات بصيغة JSON، حاول قراءتها من $_POST (لطلبات $.post)
    if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
        $data = $_POST;
    }

    // التحقق من وجود الإجراء المطلوب
    if (empty($data['action'])) {
        $response['message'] = 'الإجراء المطلوب غير محدد';
        echo json_encode($response);
        exit();
    }

    $pdo = getDBConnection(); // الحصول على اتصال قاعدة البيانات

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // معالجة إجراء إنشاء معاملة جديدة
        if ($data['action'] === 'create_transaction') {
            // التحقق من البيانات المطلوبة لإنشاء المعاملة
            if (empty($data['items']) || !isset($data['total']) || !isset($data['payment_method'])) {
                $response['message'] = 'بيانات المعاملة غير كاملة لإنشاء عملية بيع.';
                echo json_encode($response);
                exit();
            }

            // استدعاء دالة إنشاء المعاملة من functions.php
            $transactionId = createTransaction([
                'customer_id'    => $data['customer_id'] ?? null,
                'customer_name'  => $data['customer_name'] ?? 'زبون عابر',
                'total'          => $data['total'],
                'payment_method' => $data['payment_method'],
                'status'         => $data['status'] ?? 'pending',
                'notes'          => $data['notes'] ?? '',
                'items'          => $data['items']
            ]);

            if ($transactionId) {
                $response['success'] = true;
                $response['message'] = 'تم إتمام عملية البيع بنجاح.';
                $response['transaction_id'] = $transactionId;

                // إذا كانت طريقة الدفع دين، قم بجلب رصيد العميل المحدث لكي يتم عرضه في الواجهة
                if ($data['payment_method'] === 'credit' && !empty($data['customer_id'])) {
                    $stmt = $pdo->prepare("SELECT credit_balance FROM customers WHERE id = ?");
                    $stmt->execute([$data['customer_id']]);
                    $customer = $stmt->fetch(PDO::FETCH_ASSOC);
                    $response['remaining_credit'] = $customer ? (float)$customer['credit_balance'] : 0;
                }
            } else {
                $response['message'] = 'فشل في إنشاء المعاملة';
            }
        }
        // معالجة إجراء تسديد الدين
        elseif ($data['action'] === 'mark_paid') {
            if (empty($data['transaction_id'])) {
                $response['message'] = 'معرف المعاملة مطلوب لتسديد الدين.';
                echo json_encode($response);
                exit();
            }

            if (markTransactionPaid($data['transaction_id'])) {
                $response = [
                    'success' => true,
                    'message' => 'تم تسديد الدين بنجاح'
                ];
            } else {
                $response['message'] = 'فشل في تسديد الدين.';
            }
        } else {
            // إذا كان الإجراء غير create_transaction أو mark_paid
            $response['message'] = 'إجراء POST غير مدعوم.';
        }
    } else {
        $response['message'] = 'طريقة الطلب غير مدعومة.';
    }

} catch (PDOException $e) {
    // إذا كنت قد بدأت معاملة في قاعدة البيانات، تأكد من التراجع عنها
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    error_log('Database Error in transactions.php: ' . $e->getMessage());
    $response['message'] = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
} catch (Exception $e) {
    error_log('General Error in transactions.php: ' . $e->getMessage());
    $response['message'] = 'حدث خطأ غير متوقع: ' . $e->getMessage();
}

echo json_encode($response);
?>