<?php
session_start();
require_once 'config.php';
require_once 'functions.php';

// تحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// معالجة حذف المنتج
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    
    try {
        $pdo = getDBConnection();
        $stmt = $pdo->prepare("DELETE FROM products WHERE id = ?");
        $stmt->execute([$id]);
        
        $_SESSION['message'] = ['type' => 'success', 'text' => 'تم حذف المنتج بنجاح'];
        header('Location: products.php');
        exit();
    } catch (PDOException $e) {
        $_SESSION['message'] = ['type' => 'danger', 'text' => 'حدث خطأ أثناء حذف المنتج: ' . $e->getMessage()];
    }
}

// جلب جميع المنتجات
// تعديل: إضافة منطق البحث
$products = [];
$searchTerm = $_GET['search'] ?? '';

try {
    $pdo = getDBConnection();
    
    if ($searchTerm) {
        $stmt = $pdo->prepare("SELECT * FROM products WHERE name LIKE ? OR category LIKE ?");
        $stmt->execute(["%$searchTerm%", "%$searchTerm%"]);
    } else {
        $stmt = $pdo->prepare("SELECT * FROM products");
        $stmt->execute();
    }
    
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    // يمكنك إضافة معالجة للخطأ هنا
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المنتجات - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen overflow-hidden">
        <?php include 'sidebar.php'; ?>

        <div class="flex-1 overflow-auto">
            <header class="bg-white shadow-sm p-4 flex justify-between items-center">
                <h2 class="text-xl font-bold text-gray-800">إدارة المنتجات</h2>
                <div class="flex items-center">
                    <span class="mr-2">مرحباً, <?php echo $_SESSION['username']; ?></span>
                    <img src="https://ui-avatars.com/api/?name=<?php echo urlencode($_SESSION['username']); ?>&background=random" class="w-8 h-8 rounded-full">
                </div>
            </header>

            <main class="p-6">
                <?php if (isset($_SESSION['message'])): ?>
                <div class="mb-4 p-4 rounded <?php echo $_SESSION['message']['type'] === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                    <?php echo $_SESSION['message']['text']; ?>
                </div>
                <?php unset($_SESSION['message']); endif; ?>

                <div class="flex justify-between items-center mb-6">
                    <h3 class="text-lg font-bold">قائمة المنتجات</h3>
                    <a href="add-product.php" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                        <i class="fas fa-plus mr-2"></i> إضافة منتج جديد
                    </a>
                </div>
                
                <div class="bg-white rounded-lg shadow p-4 mb-6">
                    <form action="products.php" method="GET" class="flex items-center space-x-4">
                        <div class="relative flex-grow">
                            <input type="text" name="search" placeholder="البحث عن منتج بالاسم أو التصنيف..." value="<?php echo htmlspecialchars($searchTerm); ?>" class="w-full pl-10 pr-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <i class="fas fa-search absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                        </div>
                        <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                            بحث
                        </button>
                        <?php if ($searchTerm): ?>
                        <a href="products.php" class="px-4 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400">
                            مسح البحث
                        </a>
                        <?php endif; ?>
                    </form>
                </div>
                
                <div class="bg-white rounded-lg shadow overflow-hidden">
                    <table class="min-w-full">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="py-3 px-4 text-right">الاسم</th>
                                <th class="py-3 px-4 text-right">السعر</th>
                                <th class="py-3 px-4 text-right">التكلفة</th>
                                <th class="py-3 px-4 text-right">المخزون</th>
                                <th class="py-3 px-4 text-right">التصنيف</th>
                                <th class="py-3 px-4 text-right">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($products) > 0): ?>
                                <?php foreach ($products as $product): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($product['name']); ?></td>
                                    <td class="py-3 px-4"><?php echo number_format($product['price'], 2); ?> د.م</td>
                                    <td class="py-3 px-4"><?php echo number_format($product['cost'], 2); ?> د.م</td>
                                    <td class="py-3 px-4"><?php echo $product['stock']; ?></td>
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($product['category']); ?></td>
                                    <td class="py-3 px-4">
                                        <a href="edit-product.php?id=<?php echo $product['id']; ?>" class="text-blue-600 hover:text-blue-800 mr-2">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="products.php?delete=<?php echo $product['id']; ?>" class="text-red-600 hover:text-red-800" onclick="return confirm('هل أنت متأكد من حذف هذا المنتج؟')">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td colspan="6" class="py-3 px-4 text-center text-gray-500">
                                        لا توجد منتجات مطابقة لنتائج البحث.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>
</body>
</html>