<?php
session_start();
require_once 'config.php';
require_once 'functions.php';

if (!isset($_SESSION['user_id']) {
    echo json_encode(['success' => false, 'message' => 'غير مسموح بالوصول']);
    exit();
}

header('Content-Type: application/json');

$action = $_POST['action'] ?? '';
$order_id = $_POST['order_id'] ?? 0;

try {
    switch ($action) {
        case 'get_order_details':
            $order = getOrderDetails($order_id);
            if ($order) {
                echo json_encode([
                    'success' => true,
                    'data' => [
                        'id' => $order['id'],
                        'customer_name' => $order['customer_name'],
                        'created_at' => date('Y/m/d H:i', strtotime($order['created_at'])),
                        'status_text' => getOrderStatusText($order['status']),
                        'payment_method' => $order['payment_method'],
                        'address' => formatOrderAddress($order),
                        'items' => getOrderItems($order_id),
                        'total' => number_format($order['total'], 2)
                    ]
                ]);
            } else {
                echo json_encode(['success' => false, 'message' => 'الطلب غير موجود']);
            }
            break;

        case 'delete_order':
            if (deleteOrder($order_id)) {
                echo json_encode(['success' => true, 'message' => 'تم الحذف بنجاح']);
            } else {
                echo json_encode(['success' => false, 'message' => 'فشل في حذف الطلب']);
            }
            break;

        default:
            echo json_encode(['success' => false, 'message' => 'إجراء غير معروف']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'حدث خطأ: ' . $e->getMessage()]);
}