<?php
session_start();
require_once 'config.php';
require_once 'functions.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// جلب سجل المعاملات
$transactions = getRecentTransactions(100); // جلب آخر 100 معاملة
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سجل المعاملات - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
        }
        .transaction-row:hover {
            background-color: #f8fafc;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen overflow-hidden">
        <?php include 'sidebar.php'; ?>

        <div class="flex-1 overflow-auto">
            <header class="bg-white shadow-sm p-4 flex justify-between items-center">
                <h2 class="text-xl font-bold text-gray-800">سجل المعاملات</h2>
                <div class="flex items-center space-x-4">
                    <div class="flex items-center">
                        <span class="mr-2">مرحباً, <?php echo $_SESSION['username']; ?></span>
                        <img src="https://ui-avatars.com/api/?name=<?php echo urlencode($_SESSION['username']); ?>&background=random" class="w-8 h-8 rounded-full">
                    </div>
                </div>
            </header>

            <main class="p-4">
                <!-- فلترة المعاملات -->
                <div class="bg-white rounded-lg shadow p-4 mb-4">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">من تاريخ</label>
                            <input type="date" id="filter-from" class="w-full p-2 border rounded-lg">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">إلى تاريخ</label>
                            <input type="date" id="filter-to" class="w-full p-2 border rounded-lg">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">حالة الدفع</label>
                            <select id="filter-status" class="w-full p-2 border rounded-lg">
                                <option value="all">الكل</option>
                                <option value="paid">مدفوعة</option>
                                <option value="unpaid">غير مدفوعة</option>
                            </select>
                        </div>
                        <div class="flex items-end">
                            <button id="apply-filters" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 w-full">
                                <i class="fas fa-filter mr-2"></i> تطبيق الفلترة
                            </button>
                        </div>
                    </div>
                </div>

                <!-- جدول المعاملات -->
                <div class="bg-white rounded-lg shadow overflow-hidden">
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">رقم الفاتورة</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">التاريخ</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الزبون</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">عدد المنتجات</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">المبلغ</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">طريقة الدفع</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الحالة</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200" id="transactions-table-body">
                                <?php foreach ($transactions as $transaction): ?>
                                <tr class="transaction-row">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $transaction['id']; ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo date('Y/m/d H:i', strtotime($transaction['date'])); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $transaction['customer_name'] ?: 'زبون عابر'; ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-center"><?php echo $transaction['items_count']; ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 text-right"><?php echo number_format($transaction['total'], 2); ?> د.م</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <?php 
                                        $payment_method = $transaction['payment_method'] ?? 'cash';
                                        echo $payment_method === 'cash' ? 'نقدي' : 'دين';
                                        ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                            <?php echo $transaction['status'] === 'paid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                                            <?php echo $transaction['status'] === 'paid' ? 'مدفوعة' : 'غير مدفوعة'; ?>
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <a href="invoice.php?id=<?php echo $transaction['id']; ?>" class="text-blue-600 hover:text-blue-900 mr-3" title="عرض الفاتورة">
                                            <i class="fas fa-file-invoice"></i>
                                        </a>
                                        <?php if ($transaction['status'] === 'unpaid'): ?>
                                        <a href="#" class="text-green-600 hover:text-green-900 mr-3 mark-paid" data-id="<?php echo $transaction['id']; ?>" title="تم الدفع">
                                            <i class="fas fa-check-circle"></i>
                                        </a>
                                        <?php endif; ?>
                                        <a href="#" class="text-red-600 hover:text-red-900 delete-transaction" data-id="<?php echo $transaction['id']; ?>" title="حذف">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- رسائل التنبيه -->
                <?php if (isset($_SESSION['message'])): ?>
                <div class="fixed bottom-4 right-4">
                    <div class="bg-<?php echo $_SESSION['message']['type'] === 'success' ? 'green' : 'red'; ?>-500 text-white px-4 py-2 rounded-lg shadow-lg">
                        <?php echo $_SESSION['message']['text']; ?>
                    </div>
                </div>
                <?php unset($_SESSION['message']); endif; ?>
            </main>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // إخفاء رسالة التنبيه بعد 3 ثواني
            setTimeout(function() {
                $('.fixed.bottom-4').fadeOut();
            }, 3000);

            // فلترة المعاملات
            $('#apply-filters').click(function() {
                const fromDate = $('#filter-from').val();
                const toDate = $('#filter-to').val();
                const status = $('#filter-status').val();
                
                $.ajax({
                    url: 'api/filter_transactions.php',
                    method: 'POST',
                    data: {
                        from_date: fromDate,
                        to_date: toDate,
                        status: status
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#transactions-table-body').html(response.html);
                        } else {
                            alert('حدث خطأ أثناء جلب البيانات');
                        }
                    },
                    error: function() {
                        alert('حدث خطأ في الاتصال بالخادم');
                    }
                });
            });

            // تمييز المعاملة كمدفوعة
            $(document).on('click', '.mark-paid', function(e) {
                e.preventDefault();
                const transactionId = $(this).data('id');
                
                if (confirm('هل أنت متأكد من أنك تريد تمييز هذه المعاملة كمدفوعة؟')) {
                    $.ajax({
                        url: 'api/transactions.php',
                        method: 'PUT',
                        data: {
                            id: transactionId,
                            status: 'paid'
                        },
                        success: function(response) {
                            if (response.success) {
                                location.reload();
                            } else {
                                alert('حدث خطأ أثناء تحديث حالة المعاملة');
                            }
                        },
                        error: function() {
                            alert('حدث خطأ في الاتصال بالخادم');
                        }
                    });
                }
            });

            // حذف المعاملة
            $(document).on('click', '.delete-transaction', function(e) {
                e.preventDefault();
                const transactionId = $(this).data('id');
                
                if (confirm('هل أنت متأكد من أنك تريد حذف هذه المعاملة؟ لا يمكن التراجع عن هذا الإجراء.')) {
                    $.ajax({
                        url: 'api/transactions.php',
                        method: 'DELETE',
                        data: {
                            id: transactionId
                        },
                        success: function(response) {
                            if (response.success) {
                                location.reload();
                            } else {
                                alert(response.message || 'حدث خطأ أثناء حذف المعاملة');
                            }
                        },
                        error: function(xhr) {
                            alert('حدث خطأ في الاتصال بالخادم: ' + xhr.responseText);
                        }
                    });
                }
            });
        });
    </script>
</body>
</html>