<?php
session_start();
require_once 'config.php';
require_once 'functions.php';

// Vérification de la connexion
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

if (!isset($_GET['id'])) {
    header('Location: transactions.php');
    exit();
}

$transactionId = (int)$_GET['id'];
$transaction = generateInvoice($transactionId);

if (!$transaction) {
    $_SESSION['message'] = ['type' => 'danger', 'text' => 'Transaction non trouvée'];
    header('Location: transactions.php');
    exit();
}

// حساب المجموع من العناصر للتأكد من صحته
$calculatedTotal = 0;
foreach ($transaction['items'] as $item) {
    $calculatedTotal += $item['total'];
}

// تحديث المجموع في البيانات إذا كان هناك اختلاف
if ($calculatedTotal != $transaction['total']) {
    $transaction['total'] = $calculatedTotal;
}
?>
<!DOCTYPE html>
<html lang="fr" dir="ltr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facture #<?php echo $transaction['id']; ?> - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
        }
        @media print {
            .no-print {
                display: none;
            }
            @page {
                size: A5;
                margin: 10mm;
            }
            body {
                width: 148mm;
                height: 210mm;
                margin: 0;
                padding: 0;
            }
            .container {
                width: 100%;
                padding: 0;
                margin: 0;
            }
            .rounded-lg {
                border-radius: 0;
            }
            .shadow-lg {
                box-shadow: none;
            }
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4">
        <div class="bg-white rounded-lg shadow-lg p-6 max-w-4xl mx-auto">
            <!-- Bouton de retour (non imprimé) -->
            <div class="no-print mb-4">
                <a href="operation.php" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 inline-block">
                    <i class="fas fa-arrow-left mr-2"></i> Retour aux transactions
                </a>
                <button onclick="window.print()" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 ml-2 inline-block">
                    <i class="fas fa-print mr-2"></i> Imprimer la facture
                </button>
            </div>

            <!-- En-tête de la facture -->
            <div class="flex justify-between items-center mb-8">
                <div>
                    <h1 class="text-3xl font-bold">Facture de vente</h1>
                    <p class="text-gray-600">Numéro de facture: <?php echo $transaction['id']; ?></p>
                </div>
                <div class="text-right">
                    <p class="text-gray-600">Date: <?php echo date('d/m/Y', strtotime($transaction['date'])); ?></p>
                    <p class="text-gray-600">Heure: <?php echo date('H:i', strtotime($transaction['date'])); ?></p>
                </div>
            </div>

            <!-- Informations du client -->
            <div class="mb-8 p-4 bg-gray-50 rounded-lg">
                <h2 class="text-xl font-bold mb-2">Client:</h2>
                <p><?php echo $transaction['customer_name'] ?: 'Client anonyme'; ?></p>
            </div>

            <!-- Détails de la facture -->
            <div class="mb-8">
                <table class="w-full border-collapse">
                    <thead>
                        <tr class="bg-gray-100">
                            <th class="py-3 px-4 text-left border">Produit</th>
                            <th class="py-3 px-4 text-center border">Quantité</th>
                            <th class="py-3 px-4 text-right border">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transaction['items'] as $item): ?>
                        <tr class="border-b">
                            <td class="py-3 px-4 border"><?php echo htmlspecialchars($item['name']); ?></td>
                            <td class="py-3 px-4 text-center border"><?php echo $item['quantity']; ?></td>
                            <td class="py-3 px-4 text-right border"><?php echo number_format($item['total'], 2); ?> DH</td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Récapitulatif de la facture -->
            <div class="flex justify-end">
                <div class="w-64">
                    <div class="flex justify-between mb-2">
                        <span class="font-bold">Sous-total:</span>
                        <span><?php echo number_format($transaction['total'], 2); ?> DH</span>
                    </div>
                    <div class="flex justify-between mb-2">
                        <span class="font-bold">Remise:</span>
                        <span>0.00 DH</span>
                    </div>
                    <div class="flex justify-between text-xl font-bold border-t pt-2">
                        <span>Total:</span>
                        <span><?php echo number_format($transaction['total'], 2); ?> DH</span>
                    </div>
                </div>
            </div>

            <!-- Pied de page -->
            <div class="mt-12 pt-4 border-t text-center text-gray-600">
                <p>Merci pour votre confiance</p>
                <p>Pour toute question, veuillez nous contacter au: 0612345678</p>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
</body>
</html>