<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once 'config.php';
require_once 'functions.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// جلب البيانات مع معالجة الأخطاء
try {
    $transactions = getRecentTransactions(5);
    $stats = getDashboardStats();
} catch (Exception $e) {
    die("حدث خطأ في جلب البيانات: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم - نظام نقاط البيع</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body { font-family: 'Tajawal', sans-serif; }
        .stat-card:hover { transform: translateY(-5px); }
    </style>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen overflow-hidden">
        <?php include 'sidebar.php'; ?>

        <div class="flex-1 overflow-auto">
            <header class="bg-white shadow-sm p-4 flex justify-between items-center">
                <h2 class="text-xl font-bold text-gray-800">لوحة التحكم</h2>
                <div class="flex items-center">
                    <span class="mr-2">مرحباً, <?php echo htmlspecialchars($_SESSION['username']); ?></span>
                    <img src="https://ui-avatars.com/api/?name=<?php echo urlencode($_SESSION['username']); ?>&background=random" class="w-8 h-8 rounded-full">
                </div>
            </header>

            <main class="p-4">
                <!-- بطاقات الإحصائيات -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                    <!-- بطاقة إجمالي المبيعات -->
                    <div class="stat-card bg-white p-4 rounded-lg shadow transition duration-300">
                        <div class="flex justify-between items-center">
                            <div>
                                <p class="text-gray-600">إجمالي المبيعات</p>
                                <h3 class="text-2xl font-bold"><?php echo number_format($stats['total_sales'] ?? 0, 2); ?> د.م</h3>
                            </div>
                            <div class="bg-blue-100 p-3 rounded-full">
                                <i class="fas fa-shopping-cart text-blue-600"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- بطاقة الأرباح الصافية -->
                    <div class="stat-card bg-white p-4 rounded-lg shadow transition duration-300">
                        <div class="flex justify-between items-center">
                            <div>
                                <p class="text-gray-600">الأرباح الصافية</p>
                                <h3 class="text-2xl font-bold"><?php echo number_format($stats['net_profit'] ?? 0, 2); ?> د.م</h3>
                            </div>
                            <div class="bg-green-100 p-3 rounded-full">
                                <i class="fas fa-chart-line text-green-600"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- بطاقة عدد الطلبات -->
                    <div class="stat-card bg-white p-4 rounded-lg shadow transition duration-300">
                        <div class="flex justify-between items-center">
                            <div>
                                <p class="text-gray-600">عدد الطلبات</p>
                                <h3 class="text-2xl font-bold"><?php echo $stats['total_orders'] ?? 0; ?></h3>
                            </div>
                            <div class="bg-purple-100 p-3 rounded-full">
                                <i class="fas fa-file-invoice text-purple-600"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- بطاقة الزبائن النشطين -->
                    <div class="stat-card bg-white p-4 rounded-lg shadow transition duration-300">
                        <div class="flex justify-between items-center">
                            <div>
                                <p class="text-gray-600">الزبائن النشطين</p>
                                <h3 class="text-2xl font-bold"><?php echo $stats['active_customers'] ?? 0; ?></h3>
                            </div>
                            <div class="bg-yellow-100 p-3 rounded-full">
                                <i class="fas fa-users text-yellow-600"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- بطاقة جديدة: قيمة المخزون -->
                    <div class="stat-card bg-white p-4 rounded-lg shadow transition duration-300">
                        <div class="flex justify-between items-center">
                            <div>
                                <p class="text-gray-600">قيمة المخزون</p>
                                <h3 class="text-2xl font-bold"><?php echo number_format($stats['inventory_value'] ?? 0, 2); ?> د.م</h3>
                            </div>
                            <div class="bg-red-100 p-3 rounded-full">
                                <i class="fas fa-boxes text-red-600"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- جدول آخر المعاملات -->
                <div class="bg-white rounded-lg shadow overflow-hidden">
                    <div class="p-4 border-b">
                        <h3 class="font-bold text-lg">آخر المعاملات</h3>
                    </div>
                    <div class="overflow-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-right">رقم الفاتورة</th>
                                    <th class="px-4 py-3 text-right">الزبون</th>
                                    <th class="px-4 py-3 text-right">التاريخ</th>
                                    <th class="px-4 py-3 text-right">المبلغ</th>
                                    <th class="px-4 py-3 text-right">الحالة</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php if (!empty($transactions)): ?>
                                    <?php foreach ($transactions as $transaction): ?>
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-4 py-3"><?php echo $transaction['id']; ?></td>
                                        <td class="px-4 py-3"><?php echo htmlspecialchars($transaction['customer_name'] ?? 'زبون عابر'); ?></td>
                                        <td class="px-4 py-3"><?php echo date('Y-m-d H:i', strtotime($transaction['date'])); ?></td>
                                        <td class="px-4 py-3"><?php echo number_format($transaction['total'], 2); ?> د.م</td>
                                        <td class="px-4 py-3">
                                            <span class="px-2 py-1 text-sm rounded-full <?php echo ($transaction['status'] ?? '') === 'paid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                                                <?php echo ($transaction['status'] ?? '') === 'paid' ? 'مسددة' : 'غير مسددة'; ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="5" class="px-4 py-3 text-center">لا توجد معاملات</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // يمكنك إضافة أي أكواد JavaScript مطلوبة هنا
        });
    </script>
</body>
</html>