<?php
session_start();
header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

$response = ['success' => false, 'message' => ''];

try {
    // 1. التحقق من تسجيل الدخول
    if (!isset($_SESSION['user_id'])) {
        $response['message'] = 'غير مسموح بالوصول';
        echo json_encode($response);
        exit();
    }

    // 2. فك تشفير بيانات الطلب سواء كانت من JSON أو POST
    $input = json_decode(file_get_contents('php://input'), true) ?: $_POST;
    $method = $_SERVER['REQUEST_METHOD'];

    // 3. معالجة الطلبات بناءً على طريقة الطلب
    if ($method === 'POST' && isset($input['action']) && $input['action'] === 'mark_paid') {
        // معالجة طلب تسديد الدين
        if (empty($input['id']) || !is_numeric($input['id'])) {
            $response['message'] = 'معرف المعاملة مطلوب';
        } else {
            // استدعاء الدالة المخصصة لتسديد الدين من ملف functions.php
            if (markTransactionPaid($input['id'])) {
                $response = ['success' => true, 'message' => 'تم تسديد الدين بنجاح'];
            } else {
                $response['message'] = 'فشل في تسديد الدين: خطأ في قاعدة البيانات';
            }
        }
    } else {
        $response['message'] = 'طريقة الطلب غير مدعومة أو الإجراء غير محدد';
    }

} catch (PDOException $e) {
    // التعامل مع أخطاء قاعدة البيانات
    $response['message'] = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
} catch (Exception $e) {
    // التعامل مع الأخطاء العامة
    $response['message'] = 'حدث خطأ غير متوقع: ' . $e->getMessage();
}

// 4. إرجاع الاستجابة النهائية
echo json_encode($response);
?>