<?php
header('Content-Type: application/json');
require_once '../../config.php';
require_once '../../functions.php';

$pdo = getDBConnection();

$response = ['success' => false, 'message' => ''];

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            // جلب جميع المنتجات أو منتج معين
            if (isset($_GET['id'])) {
                $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $product = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($product) {
                    $response = ['success' => true, 'data' => $product];
                } else {
                    $response['message'] = 'المنتج غير موجود';
                }
            } else {
                $stmt = $pdo->query("SELECT * FROM products ORDER BY name ASC");
                $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
                $response = ['success' => true, 'data' => $products];
            }
            break;
            
        case 'POST':
            // إضافة منتج جديد
            $data = json_decode(file_get_contents('php://input'), true);
            
            if (!isset($data['name'], $data['price'], $data['cost'], $data['stock'], $data['category'], $data['color'])) {
                $response['message'] = 'بيانات غير مكتملة';
                break;
            }
            
            $stmt = $pdo->prepare("INSERT INTO products (name, price, cost, stock, category, color) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->execute([
                $data['name'],
                $data['price'],
                $data['cost'],
                $data['stock'],
                $data['category'],
                $data['color']
            ]);
            
            $response = [
                'success' => true,
                'message' => 'تم إضافة المنتج بنجاح',
                'id' => $pdo->lastInsertId()
            ];
            break;
            
        case 'PUT':
            // تحديث منتج موجود
            $data = json_decode(file_get_contents('php://input'), true);
            
            if (!isset($data['id'])) {
                $response['message'] = 'معرف المنتج مطلوب';
                break;
            }
            
            $updates = [];
            $params = [];
            
            if (isset($data['name'])) {
                $updates[] = 'name = ?';
                $params[] = $data['name'];
            }
            
            if (isset($data['price'])) {
                $updates[] = 'price = ?';
                $params[] = $data['price'];
            }
            
            if (isset($data['cost'])) {
                $updates[] = 'cost = ?';
                $params[] = $data['cost'];
            }
            
            if (isset($data['stock'])) {
                $updates[] = 'stock = ?';
                $params[] = $data['stock'];
            }
            
            if (isset($data['category'])) {
                $updates[] = 'category = ?';
                $params[] = $data['category'];
            }
            
            if (isset($data['color'])) {
                $updates[] = 'color = ?';
                $params[] = $data['color'];
            }
            
            if (empty($updates)) {
                $response['message'] = 'لا توجد بيانات للتحديث';
                break;
            }
            
            $params[] = $data['id'];
            $sql = "UPDATE products SET " . implode(', ', $updates) . " WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            
            $response = ['success' => true, 'message' => 'تم تحديث المنتج بنجاح'];
            break;
            
        case 'DELETE':
            // حذف منتج
            if (!isset($_GET['id'])) {
                $response['message'] = 'معرف المنتج مطلوب';
                break;
            }
            
            $stmt = $pdo->prepare("DELETE FROM products WHERE id = ?");
            $stmt->execute([$_GET['id']]);
            
            $response = ['success' => true, 'message' => 'تم حذف المنتج بنجاح'];
            break;
            
        default:
            $response['message'] = 'طريقة الطلب غير مدعومة';
            break;
    }
} catch (PDOException $e) {
    $response['message'] = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
}

echo json_encode($response);