<?php
require_once '../config.php';
require_once '../functions.php';

header('Content-Type: application/json');

try {
    $fromDate = $_POST['from_date'] ?? null;
    $toDate = $_POST['to_date'] ?? null;
    $status = $_POST['status'] ?? 'all';

    $transactions = filterTransactions($fromDate, $toDate, $status);
    
    $html = '';
    foreach ($transactions as $transaction) {
        $html .= '<tr class="transaction-row">';
        $html .= '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">'.$transaction['id'].'</td>';
        $html .= '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">'.date('Y/m/d H:i', strtotime($transaction['date'])).'</td>';
        $html .= '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">'.($transaction['customer_name'] ?: 'زبون عابر').'</td>';
        $html .= '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-center">'.$transaction['items_count'].'</td>';
        $html .= '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 text-right">'.number_format($transaction['total'], 2).' د.م</td>';
        $html .= '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">';
        $html .= ($transaction['payment_method'] === 'cash' ? 'نقدي' : 'دين');
        $html .= '</td>';
        $html .= '<td class="px-6 py-4 whitespace-nowrap">';
        $html .= '<span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full ';
        $html .= ($transaction['status'] === 'paid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800').'">';
        $html .= ($transaction['status'] === 'paid' ? 'مدفوعة' : 'غير مدفوعة');
        $html .= '</span>';
        $html .= '</td>';
        $html .= '<td class="px-6 py-4 whitespace-nowrap text-sm font-medium">';
        $html .= '<a href="invoice.php?id='.$transaction['id'].'" class="text-blue-600 hover:text-blue-900 mr-3" title="عرض الفاتورة">';
        $html .= '<i class="fas fa-file-invoice"></i>';
        $html .= '</a>';
        if ($transaction['status'] === 'unpaid') {
            $html .= '<a href="#" class="text-green-600 hover:text-green-900 mr-3 mark-paid" data-id="'.$transaction['id'].'" title="تم الدفع">';
            $html .= '<i class="fas fa-check-circle"></i>';
            $html .= '</a>';
        }
        $html .= '<a href="#" class="text-red-600 hover:text-red-900 delete-transaction" data-id="'.$transaction['id'].'" title="حذف">';
        $html .= '<i class="fas fa-trash-alt"></i>';
        $html .= '</a>';
        $html .= '</td>';
        $html .= '</tr>';
    }

    echo json_encode([
        'success' => true,
        'html' => $html
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'حدث خطأ: ' . $e->getMessage()
    ]);
}