<?php
session_start();
header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

$pdo = getDBConnection();
$response = ['success' => false, 'message' => ''];

try {
    if (!isset($_SESSION['user_id'])) {
        $response['message'] = 'غير مسموح بالوصول';
        echo json_encode($response);
        exit();
    }

    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if (empty($data['customer_id']) || empty($data['product_id']) || !isset($data['discount'])) {
        $response['message'] = 'بيانات غير كاملة';
        echo json_encode($response);
        exit();
    }

    // جلب الخصومات الحالية
    $stmt = $pdo->prepare("SELECT discounts FROM customers WHERE id = ?");
    $stmt->execute([$data['customer_id']]);
    $customer = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$customer) {
        $response['message'] = 'الزبون غير موجود';
        echo json_encode($response);
        exit();
    }

    $discounts = json_decode($customer['discounts'], true) ?? [];
    $discounts[$data['product_id']] = (float)$data['discount'];

    // تحديث الخصومات
    $stmt = $pdo->prepare("UPDATE customers SET discounts = ? WHERE id = ?");
    $stmt->execute([
        json_encode($discounts, JSON_UNESCAPED_UNICODE),
        $data['customer_id']
    ]);

    $response = ['success' => true, 'message' => 'تم تحديث الخصم بنجاح'];

} catch (PDOException $e) {
    $response['message'] = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
    error_log('Database error in update_discount.php: ' . $e->getMessage());
} catch (Exception $e) {
    $response['message'] = 'حدث خطأ غير متوقع: ' . $e->getMessage();
    error_log('Unexpected error in update_discount.php: ' . $e->getMessage());
}

echo json_encode($response);