<?php
session_start();
header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

$pdo = getDBConnection();
$response = ['success' => false, 'message' => ''];

try {
    // التحقق من تسجيل الدخول
    if (!isset($_SESSION['user_id'])) {
        http_response_code(401);
        $response['message'] = 'غير مسموح بالوصول';
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit();
    }

    switch ($_SERVER['REQUEST_METHOD']) {
        case 'POST':
            $input = file_get_contents('php://input');
            $data = json_decode($input, true) ?: $_POST;
            
            if (empty($data['id'])) {
                $response['message'] = 'معرف المعاملة مطلوب';
                http_response_code(400);
                break;
            }

            if (isset($data['action']) && $data['action'] === 'mark_paid') {
                $pdo->beginTransaction();
                
                // 1. تحديث حالة المعاملة
                $stmt = $pdo->prepare("UPDATE transactions SET status = 'paid' WHERE id = ?");
                $stmt->execute([$data['id']]);
                
                // 2. جلب معلومات المعاملة لتحديث رصيد الزبون
                $stmt = $pdo->prepare("SELECT customer_id, total FROM transactions WHERE id = ?");
                $stmt->execute([$data['id']]);
                $transaction = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($transaction && $transaction['customer_id']) {
                    // 3. تحديث رصيد الزبون
                    $stmt = $pdo->prepare("UPDATE customers SET credit_balance = credit_balance - ? WHERE id = ?");
                    $stmt->execute([$transaction['total'], $transaction['customer_id']]);
                }
                
                $pdo->commit();
                $response = ['success' => true, 'message' => 'تم تسديد الدين بنجاح'];
            } else {
                $response['message'] = 'إجراء غير معروف';
                http_response_code(400);
            }
            break;
        
        case 'DELETE':
            parse_str(file_get_contents("php://input"), $data);
            $id = $data['id'] ?? null;

            if ($id) {
                $success = deleteTransaction($id);
                if ($success) {
                    $response = [
                        'success' => true,
                        'message' => 'تم حذف الطلبية بنجاح'
                    ];
                } else {
                    $response['message'] = 'فشل في حذف الطلبية';
                    http_response_code(500);
                }
            } else {
                $response['message'] = 'معرّف الطلبية مطلوب';
                http_response_code(400);
            }
            break;
            
        default:
            $response['message'] = 'طريقة الطلب غير مدعومة';
            http_response_code(405);
            break;
    }
} catch (PDOException $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $response['message'] = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
    http_response_code(500);
    error_log("PDO Error: " . $e->getMessage());
} catch (Exception $e) {
    $response['message'] = 'حدث خطأ غير متوقع: ' . $e->getMessage();
    http_response_code(500);
}

echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>