<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

$pdo = getDBConnection();
$response = ['success' => false, 'message' => ''];

try {
    session_start();
    if (!isset($_SESSION['user_id'])) {
        $response['message'] = 'غير مسموح بالوصول';
        echo json_encode($response);
        exit();
    }

    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            if (isset($_GET['id'])) {
                $stmt = $pdo->prepare("SELECT * FROM customers WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $customer = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($customer) {
                    $customer['discounts'] = json_decode($customer['discounts'], true) ?: [];
                    $response = ['success' => true, 'data' => $customer];
                } else {
                    $response['message'] = 'الزبون غير موجود';
                }
            } else {
                $stmt = $pdo->query("SELECT * FROM customers ORDER BY name ASC");
                $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
                $response = ['success' => true, 'data' => $customers];
            }
            break;
            
        case 'POST':
            $data = json_decode(file_get_contents('php://input'), true) ?: $_POST;
            
            if (empty($data['name'])) {
                $response['message'] = 'اسم الزبون مطلوب';
                break;
            }
            
            $stmt = $pdo->prepare("INSERT INTO customers (name, phone, address, credit_balance) VALUES (?, ?, ?, ?)");
            $stmt->execute([
                trim($data['name']),
                $data['phone'] ?? null,
                $data['address'] ?? null,
                $data['credit_balance'] ?? 0
            ]);
            
            $response = [
                'success' => true,
                'message' => 'تم إضافة الزبون بنجاح',
                'data' => ['id' => $pdo->lastInsertId()]
            ];
            break;
            
        case 'PUT':
            $data = json_decode(file_get_contents('php://input'), true) ?: $_POST;
            
            if (empty($data['id'])) {
                $response['message'] = 'معرف الزبون مطلوب';
                break;
            }
            
            $stmt = $pdo->prepare("UPDATE customers SET name = ?, phone = ?, address = ?, credit_balance = ? WHERE id = ?");
            $stmt->execute([
                trim($data['name']),
                $data['phone'] ?? null,
                $data['address'] ?? null,
                $data['credit_balance'] ?? 0,
                $data['id']
            ]);
            
            $response = [
                'success' => true,
                'message' => 'تم تحديث الزبون بنجاح'
            ];
            break;
            
        case 'DELETE':
            $data = json_decode(file_get_contents('php://input'), true) ?: $_POST;
            
            if (empty($data['id'])) {
                $response['message'] = 'معرف الزبون مطلوب';
                break;
            }
            
            // التحقق من عدم وجود معاملات مرتبطة بالزبون
            $stmt = $pdo->prepare("SELECT COUNT(*) FROM transactions WHERE customer_id = ?");
            $stmt->execute([$data['id']]);
            $hasTransactions = $stmt->fetchColumn();
            
            if ($hasTransactions) {
                $response['message'] = 'لا يمكن حذف زبون لديه معاملات مسجلة';
                break;
            }
            
            $stmt = $pdo->prepare("DELETE FROM customers WHERE id = ?");
            $stmt->execute([$data['id']]);
            
            if ($stmt->rowCount() > 0) {
                $response = ['success' => true, 'message' => 'تم حذف الزبون بنجاح'];
            } else {
                $response['message'] = 'الزبون غير موجود';
            }
            break;
            
        default:
            $response['message'] = 'طريقة الطلب غير مدعومة';
            break;
    }
} catch (PDOException $e) {
    $response['message'] = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
} catch (Exception $e) {
    $response['message'] = 'حدث خطأ غير متوقع: ' . $e->getMessage();
}

echo json_encode($response);