<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

$pdo = getDBConnection();
$response = ['success' => false, 'message' => ''];

try {
    if (!isset($_SESSION['user_id'])) {
        $response['message'] = 'غير مسموح بالوصول';
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit();
    }

    switch ($_SERVER['REQUEST_METHOD']) {
        case 'POST':
            $data = json_decode(file_get_contents('php://input'), true) ?: $_POST;
            
            // التحقق من وجود الأعمدة قبل الإدراج
            $columns = [];
            $values = [];
            $placeholders = [];
            
            // الحقول الإجبارية
            if (empty($data['name'])) {
                $response['message'] = 'اسم الزبون مطلوب';
                break;
            }
            
            $columns[] = 'name';
            $values[] = trim($data['name']);
            $placeholders[] = '?';
            
            // الحقول الاختيارية
            $optionalFields = ['phone', 'address', 'credit_balance', 'discounts'];
            foreach ($optionalFields as $field) {
                if (isset($data[$field])) {
                    $columns[] = $field;
                    $values[] = ($field === 'discounts') ? json_encode($data[$field]) : $data[$field];
                    $placeholders[] = '?';
                }
            }
            
            $sql = "INSERT INTO customers (" . implode(', ', $columns) . ") 
                    VALUES (" . implode(', ', $placeholders) . ")";
            $stmt = $pdo->prepare($sql);
            $success = $stmt->execute($values);
            
            if ($success) {
                $response = [
                    'success' => true,
                    'message' => 'تم إضافة الزبون بنجاح',
                    'data' => ['id' => $pdo->lastInsertId()]
                ];
            } else {
                $response['message'] = 'فشل في إضافة الزبون';
            }
            break;
            
        // باقي حالات switch...
    }
} catch (PDOException $e) {
    $response['message'] = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
    error_log("PDO Error: " . $e->getMessage());
}

echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>