<?php
session_start();
header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

$pdo = getDBConnection();
$response = ['success' => false, 'message' => ''];

try {
    if (!isset($_SESSION['user_id'])) {
        $response['message'] = 'غير مسموح بالوصول';
        echo json_encode($response);
        exit();
    }

    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
        if (empty($data['id']) || !isset($data['discounts'])) {
            $response['message'] = 'بيانات غير كاملة';
            echo json_encode($response);
            exit();
        }

        $stmt = $pdo->prepare("UPDATE customers SET discounts = ? WHERE id = ?");
        $stmt->execute([
            json_encode($data['discounts'], 
            $data['id']
        ]);

        $response = [
            'success' => true,
            'message' => 'تم تحديث الخصومات بنجاح'
        ];
    }
} catch (PDOException $e) {
    $response['message'] = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
    error_log('Database error in customers.php: ' . $e->getMessage());
} catch (Exception $e) {
    $response['message'] = 'حدث خطأ غير متوقع: ' . $e->getMessage();
    error_log('Unexpected error in customers.php: ' . $e->getMessage());
}

echo json_encode($response);