<?php
session_start();
require_once 'config.php';
require_once 'functions.php';

// تحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}



// معالجة إضافة المنتج
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $price = (float)$_POST['price'];
    $cost = (float)$_POST['cost'];
    $stock = (int)$_POST['stock'];
    $category = trim($_POST['category']);
    $color = trim($_POST['color']);
    
    try {
        $pdo = getDBConnection();
        $stmt = $pdo->prepare("INSERT INTO products (name, price, cost, stock, category, color) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$name, $price, $cost, $stock, $category, $color]);
        
        $_SESSION['message'] = ['type' => 'success', 'text' => 'تم إضافة المنتج بنجاح'];
        header('Location: products.php');
        exit();
    } catch (PDOException $e) {
        $_SESSION['message'] = ['type' => 'danger', 'text' => 'حدث خطأ أثناء إضافة المنتج: ' . $e->getMessage()];
    }
}

// جلب التصنيفات
$categories = getCategories();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إضافة منتج جديد - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen overflow-hidden">
        <!-- الشريط الجانبي -->
        <?php include 'sidebar.php'; ?>

        <!-- المحتوى الرئيسي -->
        <div class="flex-1 overflow-auto">
            <header class="bg-white shadow-sm p-4 flex justify-between items-center">
                <h2 class="text-xl font-bold text-gray-800">إضافة منتج جديد</h2>
                <div class="flex items-center">
                    <span class="mr-2">مرحباً, <?php echo $_SESSION['username']; ?></span>
                    <img src="https://ui-avatars.com/api/?name=<?php echo urlencode($_SESSION['username']); ?>&background=random" class="w-8 h-8 rounded-full">
                </div>
            </header>

            <main class="p-6">
                <!-- رسائل النظام -->
                <?php if (isset($_SESSION['message'])): ?>
                <div class="mb-4 p-4 rounded <?php echo $_SESSION['message']['type'] === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                    <?php echo $_SESSION['message']['text']; ?>
                </div>
                <?php unset($_SESSION['message']); endif; ?>

                <div class="bg-white rounded-lg shadow p-6">
                    <form method="POST">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="name" class="block text-gray-700 mb-2">اسم المنتج:</label>
                                <input type="text" id="name" name="name" class="w-full p-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                            </div>
                            <div>
                                <label for="price" class="block text-gray-700 mb-2">سعر البيع (د.م):</label>
                                <input type="number" id="price" name="price" step="0.01" min="0" class="w-full p-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                            </div>
                            <div>
                                <label for="cost" class="block text-gray-700 mb-2">تكلفة الشراء (د.م):</label>
                                <input type="number" id="cost" name="cost" step="0.01" min="0" class="w-full p-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                            </div>
                            <div>
                                <label for="stock" class="block text-gray-700 mb-2">الكمية في المخزن:</label>
                                <input type="number" id="stock" name="stock" min="0" class="w-full p-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                            </div>
                            <div>
                                <label for="category" class="block text-gray-700 mb-2">التصنيف:</label>
                                <select id="category" name="category" class="w-full p-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                                    <option value="">اختر تصنيفاً</option>
                                    <?php foreach ($categories as $category): ?>
                                    <option value="<?php echo htmlspecialchars($category); ?>"><?php echo htmlspecialchars($category); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div>
                                <label for="color" class="block text-gray-700 mb-2">لون البطاقة:</label>
                                <input type="color" id="color" name="color" class="w-full h-10 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" value="#3B82F6">
                            </div>
                        </div>
                        <div class="mt-6">
                            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                                <i class="fas fa-save mr-2"></i> حفظ المنتج
                            </button>
                            <a href="products.php" class="px-4 py-2 bg-gray-200 text-gray-800 rounded-lg hover:bg-gray-300 ml-2">
                                <i class="fas fa-times mr-2"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>