<?php
require 'db.php';

$filtre = $_GET['filtre'] ?? '';
$recherche = $_GET['recherche'] ?? '';

$sql = "SELECT * FROM colis WHERE 1=1";
$params = [];

if (!empty($filtre)) {
    $sql .= " AND statut = ?";
    $params[] = $filtre;
}

if (!empty($recherche)) {
    $sql .= " AND (nom LIKE ? OR prenom LIKE ? OR ville LIKE ? OR telephone LIKE ?)";
    $params = array_merge($params, array_fill(0, 4, "%$recherche%"));
}

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$colis = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Liste des Colis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Liste des Colis</h2>
    <form method="get" class="row g-2 mb-3">
        <div class="col-md-4">
            <input type="text" name="recherche" class="form-control" placeholder="Rechercher..." value="<?= htmlspecialchars($recherche) ?>">
        </div>
        <div class="col-md-3">
            <select name="filtre" class="form-select">
                <option value="">-- Tous les statuts --</option>
                <?php foreach (['en attente', 'livré', 'annulé'] as $stat): ?>
                    <option value="<?= $stat ?>" <?= $filtre == $stat ? 'selected' : '' ?>><?= ucfirst($stat) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">Filtrer</button>
        </div>
        <div class="col-md-3 text-end">
            <a href="ajouter_colis.php" class="btn btn-success w-100">+ Ajouter un Colis</a>
        </div>
    </form>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th><th>Nom</th><th>Prénom</th><th>Ville</th><th>Téléphone</th><th>Adresse</th><th>Montant</th><th>Statut</th><th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($colis as $colis): ?>
            <tr>
                <td><?= $colis['id'] ?></td>
                <td><?= $colis['nom'] ?></td>
                <td><?= $colis['prenom'] ?></td>
                <td><?= $colis['ville'] ?></td>
                <td><?= $colis['telephone'] ?></td>
                <td><?= $colis['adresse'] ?></td>
                <td><?= $colis['montant'] ?> DH</td>
                <td><?= $colis['statut'] ?></td>
                <td>
                    <a href="modifier_colis.php?id=<?= $colis['id'] ?>" class="btn btn-sm btn-warning">Modifier</a>
                    <a href="supprimer_colis.php?id=<?= $colis['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Supprimer ce colis ?')">Supprimer</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
