<?php
require 'db.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $stmt = $pdo->prepare("INSERT INTO colis (nom, prenom, ville, telephone, adresse, montant, statut) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $_POST['nom'], $_POST['prenom'], $_POST['ville'], $_POST['telephone'],
        $_POST['adresse'], $_POST['montant'], $_POST['statut']
    ]);
    header("Location: liste_colis.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Ajouter un Colis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Ajouter un nouveau Colis</h2>
    <form method="post">
        <?php foreach (['nom', 'prenom', 'ville', 'telephone', 'adresse', 'montant', 'statut'] as $field): ?>
            <div class="mb-3">
                <label class="form-label"><?= ucfirst($field) ?></label>
                <input type="<?= $field == 'montant' ? 'number' : 'text' ?>" step="0.01" name="<?= $field ?>" class="form-control" required>
            </div>
        <?php endforeach; ?>
        <button type="submit" class="btn btn-primary">Ajouter</button>
        <a href="liste_colis.php" class="btn btn-secondary">Retour</a>
    </form>
</div>
</body>
</html>
