<?php
require 'db.php';

$id = $_GET['id'] ?? null;
if (!$id) die("ID invalide.");

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $stmt = $pdo->prepare("UPDATE colis SET nom=?, prenom=?, ville=?, telephone=?, adresse=?, montant=?, statut=? WHERE id=?");
    $stmt->execute([
        $_POST['nom'], $_POST['prenom'], $_POST['ville'], $_POST['telephone'],
        $_POST['adresse'], $_POST['montant'], $_POST['statut'], $id
    ]);
    header("Location: liste_colis.php");
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM colis WHERE id = ?");
$stmt->execute([$id]);
$colis = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$colis) die("Colis introuvable.");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Modifier Colis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Modifier le Colis</h2>
    <form method="post">
        <?php foreach (['nom', 'prenom', 'ville', 'telephone', 'adresse', 'montant', 'statut'] as $field): ?>
            <div class="mb-3">
                <label class="form-label"><?= ucfirst($field) ?></label>
                <input type="<?= $field == 'montant' ? 'number' : 'text' ?>" step="0.01" name="<?= $field ?>" class="form-control" required value="<?= htmlspecialchars($colis[$field]) ?>">
            </div>
        <?php endforeach; ?>
        <button type="submit" class="btn btn-success">Enregistrer</button>
        <a href="liste_colis.php" class="btn btn-secondary">Annuler</a>
    </form>
</div>
</body>
</html>
