<?php
require 'db.php';
$stmt = $pdo->query("SELECT * FROM colis");
$colis = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Liste des Colis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2 class="mb-4">Liste des Colis</h2>
    <a href="ajouter_colis.php" class="btn btn-primary mb-3">Ajouter un nouveau colis</a>
    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>ID</th><th>Nom</th><th>Prénom</th><th>Ville</th><th>Téléphone</th><th>Adresse</th><th>Montant</th><th>Statut</th><th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($colis as $c): ?>
            <tr>
                <td><?= $c['id'] ?></td>
                <td><?= htmlspecialchars($c['nom']) ?></td>
                <td><?= htmlspecialchars($c['prenom']) ?></td>
                <td><?= htmlspecialchars($c['ville']) ?></td>
                <td><?= htmlspecialchars($c['telephone']) ?></td>
                <td><?= htmlspecialchars($c['adresse']) ?></td>
                <td><?= $c['montant'] ?> DH</td>
                <td><?= htmlspecialchars($c['statut']) ?></td>
                <td>
                    <a href="modifier_colis.php?id=<?= $c['id'] ?>" class="btn btn-warning btn-sm">Modifier</a>
                    <a href="supprimer_colis.php?id=<?= $c['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ce colis ?');">Supprimer</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
