<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suivi des Colis - Maroc Livraison</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            margin: 0;
            font-family: 'Inter', sans-serif;
            background-color: #f4f4f4;
            color: #333;
        }
        header {
            background-color: #1c3d2f;
            color: white;
            padding: 20px 40px;
            text-align: center;
        }
        .suivi-container {
            max-width: 800px;
            margin: 40px auto;
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        .search-box {
            display: flex;
            margin-bottom: 30px;
        }
        .search-box input {
            flex: 1;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 8px 0 0 8px;
            font-size: 16px;
        }
        .search-box button {
            padding: 12px 20px;
            background-color: #1c3d2f;
            color: white;
            border: none;
            border-radius: 0 8px 8px 0;
            cursor: pointer;
            transition: background 0.3s ease;
        }
        .search-box button:hover {
            background-color: #165b40;
        }
        .timeline {
            position: relative;
            padding-left: 30px;
            margin-top: 20px;
        }
        .timeline-item {
            position: relative;
            padding-bottom: 30px;
            border-left: 2px solid #1c3d2f;
            padding-left: 25px;
        }
        .timeline-item:last-child {
            border-left: 2px solid transparent;
        }
        .timeline-dot {
            position: absolute;
            left: -10px;
            top: 0;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background-color: #1c3d2f;
        }
        .timeline-content {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
        }
        .timeline-date {
            font-size: 14px;
            color: #7f8c8d;
            margin-bottom: 5px;
        }
        .colis-info {
            background: #f1f8e9;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        .info-row {
            display: flex;
            margin-bottom: 10px;
        }
        .info-label {
            font-weight: 600;
            width: 150px;
            color: #1c3d2f;
        }
        footer {
            text-align: center;
            padding: 20px;
            background-color: #e0e0e0;
            font-size: 14px;
        }
    </style>
</head>
<body>

<header>
    <h1>Maroc Livraison</h1>
    <p>Suivez votre colis en temps réel</p>
</header>

<div class="suivi-container">
    <h2 style="color: #1c3d2f; margin-bottom: 20px;">Suivi de Colis</h2>
    
    <div class="search-box">
        <input type="text" id="numero-colis" placeholder="Entrez le numéro de suivi (ex: ML2025001)">
        <button onclick="rechercherColis()">Rechercher</button>
    </div>
    
    <div id="resultats-colis">
        <!-- سيتم عرض نتائج البحث هنا -->
        <div style="text-align: center; padding: 40px 0;">
            <img src="https://cdn-icons-png.flaticon.com/512/4476/4476876.png" width="100" style="opacity: 0.6;">
            <p style="color: #7f8c8d; margin-top: 15px;">Entrez un numéro de suivi pour afficher les détails du colis</p>
        </div>
    </div>
</div>

<footer>
    &copy; 2025 Maroc Livraison - Tous droits réservés.
</footer>

<script>
function rechercherColis() {
    const numeroColis = document.getElementById('numero-colis').value.trim();
    const resultatsDiv = document.getElementById('resultats-colis');
    
    if (numeroColis === '') {
        alert('Veuillez entrer un numéro de suivi valide');
        return;
    }
    
    // عرض رسالة تحميل
    resultatsDiv.innerHTML = `
        <div style="text-align: center; padding: 20px;">
            <div class="spinner" style="border: 4px solid #f3f3f3; border-top: 4px solid #1c3d2f; border-radius: 50%; width: 30px; height: 30px; animation: spin 1s linear infinite; margin: 0 auto;"></div>
            <p style="margin-top: 15px;">Recherche du colis en cours...</p>
        </div>
    `;
    
    // هنا يمكنك إضافة اتصال AJAX بالخادوم للحصول على البيانات الفعلية
    // هذا مثال للبيانات الوهمية فقط لأغراض العرض
    setTimeout(() => {
        // بيانات وهمية للعرض (استبدل هذا بالاتصال الحقيقي بقاعدة البيانات)
        const colisTrouve = {
            found: true,
            data: {
                'numero': numeroColis,
                'statut': 'En transit',
                'destinataire': 'Mohamed Amine',
                'ville': 'Casablanca',
                'date_expedition': '2025-04-15',
                'date_livraison_prevue': '2025-04-20'
            },
            historique: [
                {
                    'date': '2025-04-18 14:30',
                    'statut': 'En transit',
                    'localisation': 'Plateforme logistique de Rabat',
                    'details': 'Le colis a quitté le centre de tri'
                },
                {
                    'date': '2025-04-16 09:15',
                    'statut': 'En traitement',
                    'localisation': 'Plateforme logistique de Casablanca',
                    'details': 'Le colis est en cours de traitement'
                },
                {
                    'date': '2025-04-15 16:45',
                    'statut': 'Enregistré',
                    'localisation': 'Agence de Casablanca',
                    'details': 'Le colis a été enregistré dans le système'
                }
            ]
        };
        
        if (colisTrouve.found) {
            afficherResultats(colisTrouve.data, colisTrouve.historique);
        } else {
            resultatsDiv.innerHTML = `
                <div style="text-align: center; padding: 40px 0;">
                    <img src="https://cdn-icons-png.flaticon.com/512/7486/7486747.png" width="100" style="opacity: 0.6;">
                    <p style="color: #e74c3c; margin-top: 15px;">Aucun colis trouvé avec ce numéro de suivi</p>
                    <p style="color: #7f8c8d;">Vérifiez le numéro et réessayez</p>
                </div>
            `;
        }
    }, 1500);
}

function afficherResultats(colis, historique) {
    const resultatsDiv = document.getElementById('resultats-colis');
    
    let html = `
        <div class="colis-info">
            <div class="info-row">
                <span class="info-label">Numéro de suivi:</span>
                <span>${colis.numero}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Statut actuel:</span>
                <span style="font-weight:600; color:#1c3d2f;">${colis.statut}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Destinataire:</span>
                <span>${colis.destinataire}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Ville de destination:</span>
                <span>${colis.ville}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Date d'expédition:</span>
                <span>${colis.date_expedition}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Date de livraison prévue:</span>
                <span>${colis.date_livraison_prevue}</span>
            </div>
        </div>
        
        <h3 style="color: #1c3d2f; margin-bottom: 15px;">Historique de suivi</h3>
        
        <div class="timeline">
    `;
    
    historique.forEach(item => {
        html += `
            <div class="timeline-item">
                <div class="timeline-dot"></div>
                <div class="timeline-content">
                    <div class="timeline-date">${item.date}</div>
                    <h4 style="color: #1c3d2f; margin: 5px 0;">${item.statut}</h4>
                    <p><strong>Localisation:</strong> ${item.localisation}</p>
                    <p>${item.details}</p>
                </div>
            </div>
        `;
    });
    
    html += `</div>`;
    resultatsDiv.innerHTML = html;
}
</script>

</body>
</html>