<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Suivi d'un Colis</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
            padding: 30px;
        }
        h1 {
            text-align: center;
            color: #1c3d2f;
        }
        .form-container {
            text-align: center;
            margin-bottom: 30px;
        }
        input[type="text"] {
            padding: 10px;
            width: 300px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 16px;
        }
        button {
            padding: 10px 20px;
            background-color: #1c3d2f;
            color: #fff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            margin-left: 10px;
            font-size: 16px;
        }
        button:hover {
            background-color: #145c3a;
        }
        .result-container {
            margin-top: 30px;
            text-align: center;
        }
        table {
            margin: 20px auto;
            border-collapse: collapse;
            width: 50%;
            background: #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        th, td {
            padding: 12px 20px;
            border-bottom: 1px solid #ddd;
            text-align: center;
        }
        th {
            background: #1c3d2f;
            color: #fff;
        }
        .message {
            font-size: 18px;
            color: #e74c3c;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<h1>Suivi d'un Colis</h1>

<div class="form-container">
    <input type="text" id="num-colis" placeholder="Entrez le numéro de colis">
    <button onclick="rechercherColis()">Rechercher</button>
</div>

<div class="result-container" id="resultat"></div>

<script>
function rechercherColis() {
    const numColis = document.getElementById('num-colis').value.trim();
    const resultatDiv = document.getElementById('resultat');

    if (numColis === '') {
        resultatDiv.innerHTML = '<div class="message">Veuillez entrer un numéro de colis.</div>';
        return;
    }

    resultatDiv.innerHTML = '<div class="message">Recherche en cours...</div>';

    fetch('recherche_colis.php?num_colis=' + encodeURIComponent(numColis))
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                resultatDiv.innerHTML = `
                    <table>
                        <thead>
                            <tr>
                                <th>Numéro de Colis</th>
                                <th>Statut</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>${data.colis.num_colis}</td>
                                <td>${data.colis.statut}</td>
                            </tr>
                        </tbody>
                    </table>
                `;
            } else {
                resultatDiv.innerHTML = `<div class="message">${data.message}</div>`;
            }
        })
        .catch(error => {
            resultatDiv.innerHTML = '<div class="message">Erreur de connexion au serveur.</div>';
        });
}
</script>

</body>
</html>
