<?php
require 'db.php';

// قائمة المدن المغربية
$villes_maroc = [
    'Casablanca',
    'Rabat',
    'Marrakech',
    'Fès',
    'Tanger',
    'Meknès',
    'Agadir',
    'Oujda',
    'Kenitra',
    'Tétouan',
    'Safi',
    'Mohammedia',
    'El Jadida',
    'Nador',
    'Beni Mellal',
    'Taza',
    'Khouribga',
    'Settat',
    'Larache',
    'Ksar El Kebir',
    'Guelmim',
    'Laâyoune',
    'Dakhla'
];

$message = '';
$message_type = '';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // تحقق إذا كان البريد الإلكتروني موجود بالفعل
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$_POST['email']]);
    if ($stmt->rowCount() > 0) {
        $message = "L'email existe déjà.";
        $message_type = 'error';
    } else {
        // كلمة المرور المشفرة
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

        // إضافة المستخدم إلى قاعدة البيانات مع user_id الذي سيولد تلقائيًا
        $stmt = $pdo->prepare("INSERT INTO users (nom, email, password, role, statut, ville) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $_POST['nom'], 
            $_POST['email'], 
            $password, 
            'client', 
            'en_attente',
            $_POST['ville']
        ]);

        // جلب user_id للمستخدم الذي تم إضافته للتأكد من أن التسجيل تم بنجاح
        $user_id = $pdo->lastInsertId();
        $message = "Inscription réussie. Attendez l'approbation du gestionnaire. Votre user_id est : " . $user_id;
        $message_type = 'success';
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inscription - Plateforme Client</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            color: var(--dark-color);
        }
        
        .auth-container {
            width: 100%;
            max-width: 500px;
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
        }
        
        .auth-header {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
        }
        
        .auth-header h2 {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .auth-header p {
            font-size: 0.9rem;
            opacity: 0.9;
        }
        
        .auth-logo {
            font-size: 2.5rem;
            margin-bottom: 15px;
            color: white;
        }
        
        .auth-body {
            padding: 30px;
        }
        
        .auth-message {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .auth-message.error {
            background-color: rgba(255, 51, 51, 0.1);
            color: var(--error-color);
            border-left: 4px solid var(--error-color);
        }
        
        .auth-message.success {
            background-color: rgba(75, 181, 67, 0.1);
            color: var(--success-color);
            border-left: 4px solid var(--success-color);
        }
        
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--dark-color);
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: all 0.3s ease;
            background-color: #f9f9f9;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
            background-color: white;
        }
        
        select.form-control {
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='currentColor' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: right 15px center;
            background-size: 15px;
        }
        
        .password-toggle {
            position: absolute;
            right: 15px;
            top: 40px;
            cursor: pointer;
            color: #777;
        }
        
        .btn {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: var(--border-radius);
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
        }
        
        .btn-primary {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            color: white;
        }
        
        .btn-primary:hover {
            background: linear-gradient(to right, var(--secondary-color), var(--primary-color));
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .auth-footer {
            text-align: center;
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #777;
            font-size: 0.9rem;
        }
        
        .auth-footer a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        
        .auth-footer a:hover {
            text-decoration: underline;
        }
        
        @media (max-width: 576px) {
            .auth-header {
                padding: 20px;
            }
            
            .auth-body {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="auth-header">
            <div class="auth-logo">
                <i class="fas fa-user-plus"></i>
            </div>
            <h2>Créer un compte</h2>
            <p>Rejoignez notre plateforme en remplissant le formulaire ci-dessous</p>
        </div>
        
        <div class="auth-body">
            <?php if ($message): ?>
                <div class="auth-message <?php echo $message_type; ?>">
                    <i class="fas <?php echo $message_type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'; ?>"></i>
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label for="nom">Nom complet</label>
                    <input type="text" name="nom" id="nom" class="form-control" required placeholder="Entrez votre nom complet">
                </div>
                
                <div class="form-group">
                    <label for="email">Adresse email</label>
                    <input type="email" name="email" id="email" class="form-control" required placeholder="Entrez votre adresse email">
                </div>
                
                <div class="form-group">
                    <label for="password">Mot de passe</label>
                    <input type="password" name="password" id="password" class="form-control" required placeholder="Créez un mot de passe sécurisé">
                    <i class="fas fa-eye password-toggle" id="togglePassword"></i>
                </div>
                
                <div class="form-group">
                    <label for="ville">Ville</label>
                    <select name="ville" id="ville" class="form-control" required>
                        <option value="">Sélectionnez votre ville</option>
                        <?php foreach ($villes_maroc as $ville): ?>
                            <option value="<?= htmlspecialchars($ville) ?>"><?= htmlspecialchars($ville) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-user-plus"></i> S'inscrire
                </button>
            </form>
            
            <div class="auth-footer">
                Vous avez déjà un compte? <a href="#">Connectez-vous</a>
            </div>
        </div>
    </div>

    <script>
        // Toggle password visibility
        const togglePassword = document.querySelector('#togglePassword');
        const password = document.querySelector('#password');
        
        togglePassword.addEventListener('click', function() {
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);
            this.classList.toggle('fa-eye-slash');
        });
    </script>
</body>
</html>