<?php
// التحقق من إرسال النموذج
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nom = $_POST['nom'] ?? '';
    $telephone = $_POST['telephone'] ?? '';
    $message = $_POST['message'] ?? '';
    
    // تنظيف البيانات
    $nom = htmlspecialchars(trim($nom));
    $telephone = htmlspecialchars(trim($telephone));
    $message = htmlspecialchars(trim($message));
    
    // التحقق من البيانات المطلوبة
    if (empty($nom) || empty($telephone) || empty($message)) {
        $erreur = "Veuillez remplir tous les champs obligatoires.";
    } else {
        // إنشاء رابط واتساب
        $whatsapp_number = "212707446000";
        $whatsapp_message = "Nouvelle réclamation:\n\n";
        $whatsapp_message .= "Nom: $nom\n";
        $whatsapp_message .= "Téléphone: $telephone\n";
        $whatsapp_message .= "Message: $message\n";
        
        $whatsapp_url = "https://wa.me/$whatsapp_number?text=" . urlencode($whatsapp_message);
        
        // توجيه المستخدم إلى واتساب
        header("Location: $whatsapp_url");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Déposer une Réclamation - TrackShip</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            color: var(--dark-color);
        }
        
        .reclamation-container {
            width: 100%;
            max-width: 600px;
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
        }
        
        .reclamation-header {
            background: linear-gradient(to right, #ff7b25, #ff5200);
            color: white;
            padding: 25px;
            text-align: center;
            position: relative;
        }
        
        .reclamation-header h2 {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .reclamation-header p {
            font-size: 0.9rem;
            opacity: 0.9;
        }
        
        .reclamation-icon {
            font-size: 2.5rem;
            margin-bottom: 15px;
            color: white;
        }
        
        .reclamation-body {
            padding: 30px;
        }
        
        .reclamation-message {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .reclamation-message.error {
            background-color: rgba(255, 51, 51, 0.1);
            color: var(--error-color);
            border-left: 4px solid var(--error-color);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--dark-color);
        }
        
        .form-group label.required:after {
            content: " *";
            color: var(--error-color);
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            outline: none;
            border-color: #ff7b25;
            box-shadow: 0 0 0 3px rgba(255, 123, 37, 0.2);
        }
        
        textarea.form-control {
            min-height: 150px;
            resize: vertical;
        }
        
        .submit-btn {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: var(--border-radius);
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            background: linear-gradient(to right, #ff7b25, #ff5200);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .submit-btn:hover {
            background: linear-gradient(to right, #ff5200, #ff7b25);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .whatsapp-info {
            margin-top: 20px;
            padding: 15px;
            background: rgba(37, 211, 102, 0.1);
            border-radius: var(--border-radius);
            border-left: 4px solid #25D366;
            display: flex;
            align-items: center;
            gap: 10px;
            color: #075E54;
        }
        
        @media (max-width: 576px) {
            .reclamation-header {
                padding: 20px;
            }
            
            .reclamation-body {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="reclamation-container">
        <div class="reclamation-header">
            <div class="reclamation-icon">
                <i class="fas fa-headset"></i>
            </div>
            <h2>Service Client</h2>
            <p>Nous sommes là pour vous aider</p>
        </div>
        
        <div class="reclamation-body">
            <?php if (!empty($erreur)): ?>
                <div class="reclamation-message error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?= $erreur ?>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label for="nom" class="required">Nom complet</label>
                    <input type="text" name="nom" id="nom" class="form-control" required placeholder="Votre nom complet">
                </div>
                
                <div class="form-group">
                    <label for="telephone" class="required">Numéro de téléphone</label>
                    <input type="tel" name="telephone" id="telephone" class="form-control" required placeholder="Votre numéro de téléphone">
                </div>
                
                <div class="form-group">
                    <label for="message" class="required">Votre message</label>
                    <textarea name="message" id="message" class="form-control" required placeholder="Décrivez votre problème ou réclamation en détail"></textarea>
                </div>
                
                <button type="submit" class="submit-btn">
                    <i class="fab fa-whatsapp"></i> Envoyer via WhatsApp
                </button>
            </form>
            
            <div class="whatsapp-info">
                <i class="fab fa-whatsapp"></i>
                <div>
                    <strong>Votre réclamation sera envoyée directement à notre service client via WhatsApp.</strong>
                    <p style="margin-top: 5px; font-size: 0.9rem;">Assurez-vous d'avoir WhatsApp installé sur votre appareil.</p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>