<?php
require 'db.php';

// التحقق من وجود ID
if (!isset($_GET['id'])) {
    die('ID non spécifié.');
}

// جلب بيانات الطرد
$id = (int) $_GET['id'];
$stmt = $pdo->prepare('SELECT * FROM colis WHERE id = ?');
$stmt->execute([$id]);
$colis = $stmt->fetch();

if (!$colis) {
    die('Colis non trouvé.');
}

// إنشاء رقم الفاتورة
$numero_facture = 'FAC-' . str_pad($colis['id'], 4, '0', STR_PAD_LEFT);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Facture</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 50px;
            color: #333;
            background: #fff;
        }
        .facture-container {
            border: 2px solid #4CAF50;
            padding: 30px;
            max-width: 700px;
            margin: auto;
            border-radius: 10px;
        }
        h1 {
            text-align: center;
            color: #4CAF50;
            margin-bottom: 40px;
        }
        .details {
            font-size: 18px;
            margin-bottom: 20px;
        }
        .details span {
            display: block;
            margin-bottom: 10px;
        }
        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 14px;
            color: #aaa;
        }
    </style>
</head>
<body onload="window.print()">

<div class="facture-container">
    <h1>Facture</h1>

    <div class="details">
        <span><strong>Numéro de facture :</strong> <?= htmlspecialchars($numero_facture) ?></span>
        <span><strong>Nom du client :</strong> <?= htmlspecialchars($colis['nom_client']) ?></span>
        <span><strong>Adresse :</strong> <?= htmlspecialchars($colis['adresse']) ?></span>
        <span><strong>Téléphone :</strong> <?= htmlspecialchars($colis['telephone']) ?></span>
        <span><strong>Montant :</strong> <?= htmlspecialchars(number_format($colis['montant'], 2)) ?> DH</span>
        <span><strong>Date :</strong> <?= htmlspecialchars(date('d/m/Y', strtotime($colis['date_creation']))) ?></span>
    </div>

    <div class="footer">
        Merci pour votre confiance.
    </div>
</div>

</body>
</html>
