<?php
session_start();
require 'db.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user'])) {
    die("Accès refusé.");
}

// الحصول على ID الطرد من الرابط
$colis_id = $_GET['id'] ?? null;
if (!$colis_id) {
    die("ID invalide.");
}

// جلب بيانات الطرد
$stmt = $pdo->prepare("SELECT * FROM colis WHERE id = ?");
$stmt->execute([$colis_id]);
$colis = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$colis) {
    die("Colis introuvable.");
}

// التحقق من صلاحية الوصول
$user = $_SESSION['user'];
$accessDenied = true;

if ($user['role'] === 'client' && $colis['user_id'] == $user['id']) {
    $accessDenied = false;
} elseif ($user['role'] === 'livreur' && $colis['ville'] === $user['ville']) {
    $accessDenied = false;
}

if ($accessDenied) {
    die("Accès refusé. Ce colis ne vous appartient pas.");
}

// عند إرسال النموذج
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    if ($user['role'] === 'livreur') {
        // livreur يغير فقط statut
        $stmt = $pdo->prepare("UPDATE colis SET statut = ? WHERE id = ?");
        $stmt->execute([$_POST['statut'], $colis_id]);
    } else {
        // client يغير جميع البيانات
        $stmt = $pdo->prepare("UPDATE colis SET nom=?, prenom=?, ville=?, telephone=?, adresse=?, montant=? WHERE id=?");
        $stmt->execute([
            $_POST['nom'], $_POST['prenom'], $_POST['ville'], $_POST['telephone'],
            $_POST['adresse'], $_POST['montant'], $colis_id
        ]);
    }
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Modifier Colis - Plateforme Client</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
            color: var(--dark-color);
        }
        
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background: white;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            padding: 20px 0;
        }
        
        .sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        
        .sidebar-logo {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--primary-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
        }
        
        .sidebar-menu li a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #555;
            text-decoration: none;
            transition: all 0.3s ease;
            gap: 10px;
        }
        
        .sidebar-menu li a:hover, 
        .sidebar-menu li a.active {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            border-left: 3px solid var(--primary-color);
        }
        
        .sidebar-menu li a i {
            width: 20px;
            text-align: center;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
            background: #f5f7fa;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .page-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: var(--dark-color);
        }
        
        .form-container {
            background: white;
            padding: 30px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            max-width: 800px;
            margin: 0 auto;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--dark-color);
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }
        
        .form-control:disabled {
            background-color: #f8f9fa;
            cursor: not-allowed;
        }
        
        .btn {
            padding: 12px 20px;
            border: none;
            border-radius: var(--border-radius);
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: var(--primary-color);
            color: white;
        }
        
        .btn-primary:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-group {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }
        
        .status-display {
            padding: 10px 15px;
            background-color: #f8f9fa;
            border-radius: var(--border-radius);
            border: 1px solid #ddd;
            font-weight: 500;
        }
        
        @media (max-width: 992px) {
            .dashboard-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
                height: auto;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <i class="fas fa-box-open"></i>
                    <span>My Delivery</span>
                </div>
            </div>
            <ul class="sidebar-menu">
                <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Tableau de board</a></li>
                <li><a href="index.php"><i class="fas fa-boxes"></i> Liste Colis</a></li>
                <li><a href="ajouter_colis.php"><i class="fas fa-plus-circle"></i> Ajouter un colis</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="page-header">
                <h1 class="page-title"><i class="fas fa-edit"></i> Modifier le Colis</h1>
            </div>
            <div class="form-container">
                <form method="post">
                    <?php 
                    $fields = ['nom', 'prenom', 'ville', 'telephone', 'adresse', 'montant'];
                    foreach ($fields as $field): ?>
                        <div class="form-group">
                            <label class="form-label"><?= ucfirst($field) ?></label>
                            <input type="<?= $field == 'montant' ? 'number' : 'text' ?>" 
                                   step="0.01" 
                                   name="<?= $field ?>" 
                                   class="form-control" 
                                   required 
                                   value="<?= htmlspecialchars($colis[$field]) ?>"
                                   <?= $user['role'] === 'livreur' ? 'disabled' : '' ?>>
                        </div>
                    <?php endforeach; ?>
                    
                    <div class="form-group">
                        <label class="form-label">Statut</label>
                        <?php if ($user['role'] === 'livreur' || $user['role'] === 'client'): ?>
                            <select name="statut" class="form-control" required>
                                <?php foreach (['en attente', 'livré', 'annulé'] as $option): ?>
                                    <option value="<?= $option ?>" <?= $colis['statut'] === $option ? 'selected' : '' ?>>
                                        <?= ucfirst($option) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        <?php endif; ?>
                    </div>
                    
                    <div class="btn-group">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Enregistrer
                        </button>
                        <a href="index.php" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Annuler
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
