<?php
session_start();
require 'db.php';

// Vérification de la connexion
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "Vous devez vous connecter d'abord";
    header('Location: login.php');
    exit();
}

// Récupération de la ville du livreur
$ville_livreur = $_SESSION['user']['ville'] ?? '';

// Application des filtres
$recherche = $_GET['recherche'] ?? '';
$filtre = $_GET['filtre'] ?? '';

// Construction de la requête SQL
$sql = "SELECT * FROM colis 
        WHERE ville = ?
        AND statut != ''"; // Afficher uniquement les colis non livrés

$params = [$ville_livreur];

if (!empty($recherche)) {
    $sql .= " AND (nom LIKE ? OR prenom LIKE ? OR telephone LIKE ?)";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
}

if (!empty($filtre)) {
    $sql .= " AND statut = ?";
    $params[] = $filtre;
}

$sql .= " ORDER BY id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$colis = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Liste des Colis - Livreur</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
            color: var(--dark-color);
        }
        
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background: white;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            padding: 20px 0;
        }
        
        .sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        
        .sidebar-logo {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--primary-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
        }
        
        .sidebar-menu li a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #555;
            text-decoration: none;
            transition: all 0.3s ease;
            gap: 10px;
        }
        
        .sidebar-menu li a:hover, 
        .sidebar-menu li a.active {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            border-left: 3px solid var(--primary-color);
        }
        
        .sidebar-menu li a i {
            width: 20px;
            text-align: center;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
            background: #f5f7fa;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .page-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: var(--dark-color);
        }
        
        .search-filter-container {
            background: white;
            padding: 20px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 30px;
        }
        
        .search-form {
            display: flex;
            gap: 10px;
        }
        
        .search-input {
            flex: 1;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 1rem;
        }
        
        .filter-select {
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 1rem;
            min-width: 200px;
        }
        
        .search-btn {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 0 20px;
            border-radius: var(--border-radius);
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .search-btn:hover {
            background: var(--secondary-color);
        }
        
        .colis-table {
            width: 100%;
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            border-collapse: separate;
            border-spacing: 0;
        }
        
        .colis-table th {
            background: var(--primary-color);
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 500;
        }
        
        .colis-table td {
            padding: 12px 15px;
            border-bottom: 1px solid #eee;
        }
        
        .colis-table tr:last-child td {
            border-bottom: none;
        }
        
        .colis-table tr:hover td {
            background: rgba(67, 97, 238, 0.05);
        }
        
        .status-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .status-en-attente {
            background: rgba(248, 210, 16, 0.2);
            color: #b38f00;
        }
        
        .status-en-cours {
            background: rgba(67, 97, 238, 0.2);
            color: var(--primary-color);
        }
        
        .status-livre {
            background: rgba(75, 181, 67, 0.2);
            color: var(--success-color);
        }
        
        .status-annule {
            background: rgba(255, 51, 51, 0.2);
            color: var(--error-color);
        }
        
        .action-btn {
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 0.8rem;
            text-decoration: none;
            margin-right: 5px;
        }
        
        .edit-btn {
            background: rgba(248, 210, 16, 0.2);
            color: #b38f00;
        }
        
        .edit-btn:hover {
            background: rgba(248, 210, 16, 0.3);
        }
        
        .no-data {
            text-align: center;
            padding: 30px;
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
        }
        
        @media (max-width: 992px) {
            .dashboard-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
                height: auto;
            }
            
            .search-form {
                flex-direction: column;
            }
            
            .filter-select {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- Menu latéral -->
        <div class="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <i class="fas fa-shipping-fast"></i>
                    <span>Mon Espace Livreur</span>
                </div>
            </div>
            <ul class="sidebar-menu">
                <li><a href="livreur.php" class="active"><i class="fas fa-boxes"></i> Mes Colis</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Déconnexion</a></li>
            </ul>
        </div>

        <!-- Contenu principal -->
        <div class="main-content">
            <div class="page-header">
                <h1 class="page-title"><i class="fas fa-boxes"></i> Mes Colis</h1>
            </div>

            <!-- Filtres de recherche -->
            <div class="search-filter-container">
                <form method="get" class="search-form">
                    <input type="text" name="recherche" class="search-input" placeholder="Rechercher par nom, téléphone..." value="<?= htmlspecialchars($recherche) ?>">
                    <select name="filtre" class="filter-select">
                        <option value="">-- Tous les statuts --</option>
                        <?php foreach (['en attente', 'en cours', 'livré', 'annulé'] as $statut_option): ?>
                            <option value="<?= $statut_option ?>" <?= $filtre === $statut_option ? 'selected' : '' ?>><?= ucfirst($statut_option) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <button type="submit" class="search-btn"><i class="fas fa-search"></i> Filtrer</button>
                </form>
            </div>

            <!-- Liste des colis -->
            <?php if (!empty($colis)): ?>
            <div style="overflow-x: auto;">
                <table class="colis-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Numéro</th>
                            <th>Nom</th>
                            <th>Prénom</th>
                            <th>Ville</th>
                            <th>Téléphone</th>
                            <th>Montant</th>
                            <th>Statut</th>
                            <th>Modifier</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($colis as $colisItem): ?>
                        <tr>
                            <td><?= $colisItem['id'] ?></td>
                            <td><?= htmlspecialchars($colisItem['num_colis']) ?></td>
                            <td><?= htmlspecialchars($colisItem['nom']) ?></td>
                            <td><?= htmlspecialchars($colisItem['prenom']) ?></td>
                            <td><?= htmlspecialchars($colisItem['ville']) ?></td>
                            <td><?= htmlspecialchars($colisItem['telephone']) ?></td>
                            <td><?= htmlspecialchars($colisItem['montant']) ?> DH</td>
                            <td>
                                <span class="status-badge status-<?= str_replace(' ', '-', strtolower($colisItem['statut'])) ?>">
                                    <?= htmlspecialchars($colisItem['statut']) ?>
                                </span>
                            </td>
                            <td>
                                <a href="colis_livreur.php?id=<?= $colisItem['id'] ?>" class="action-btn edit-btn">
                                    <i class="fas fa-edit"></i> Statut
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php else: ?>
                <div class="no-data">
                    <i class="fas fa-box-open" style="font-size: 3rem; color: #ccc; margin-bottom: 15px;"></i>
                    <h3>Aucun colis trouvé</h3>
                    <p>Aucun colis disponible dans votre ville.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>