<?php
session_start();
require 'db.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "يجب تسجيل الدخول أولاً";
    header('Location: login.php');
    exit();
}

// تنفيذ البحث والفلاتر
$recherche = $_GET['recherche'] ?? '';
$filtre = $_GET['filtre'] ?? '';

// قاعدة الاستعلام
$sql = "SELECT c.* FROM colis c
        INNER JOIN users u ON c.user_id = u.id
        WHERE c.user_id = ?
        AND u.statut = 'actif'";

// إضافة شروط البحث إن وُجد
$params = [$_SESSION['user']['id']];

if (!empty($recherche)) {
    $sql .= " AND (c.nom LIKE ? OR c.prenom LIKE ? OR c.ville LIKE ?)";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
}

if (!empty($filtre)) {
    $sql .= " AND c.statut = ?";
    $params[] = $filtre;
}

$sql .= " ORDER BY c.id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$colis = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Liste des Colis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Liste des Colis</h2>

    <!-- Formulaire de recherche et filtre -->
    <form method="get" class="row g-2 mb-3">
        <div class="col-md-4">
            <input type="text" name="recherche" class="form-control" placeholder="Rechercher..." value="<?= htmlspecialchars($recherche) ?>">
        </div>
        <div class="col-md-3">
            <select name="filtre" class="form-select">
                <option value="">-- Tous les statuts --</option>
                <?php foreach (['en attente', 'livré', 'annulé'] as $statut_option): ?>
                    <option value="<?= $statut_option ?>" <?= $filtre === $statut_option ? 'selected' : '' ?>><?= ucfirst($statut_option) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">Filtrer</button>
        </div>
        <div class="col-md-3 text-end">
            <a href="ajouter_colis.php" class="btn btn-success w-100">+ Ajouter un Colis</a>
        </div>
    </form>

    <?php if (!empty($colis)): ?>
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Numéro de Colis</th>
                <th>Nom</th>
                <th>Prénom</th>
                <th>Ville</th>
                <th>Téléphone</th>
                <th>Adresse</th>
                <th>Montant</th>
                <th>Statut</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($colis as $colisItem): ?>
            <tr>
                <td><?= $colisItem['id'] ?></td>
                <td><?= $colisItem['num_colis'] ?? '-' ?></td> <!-- Affichage du numéro du colis -->
                <td><?= htmlspecialchars($colisItem['nom']) ?></td>
                <td><?= htmlspecialchars($colisItem['prenom']) ?></td>
                <td><?= htmlspecialchars($colisItem['ville']) ?></td>
                <td><?= htmlspecialchars($colisItem['telephone']) ?></td>
                <td><?= htmlspecialchars($colisItem['adresse']) ?></td>
                <td><?= htmlspecialchars($colisItem['montant']) ?> DH</td>
                <td><?= htmlspecialchars($colisItem['statut']) ?></td>
                <td>
                    <a href="modifier_colis.php?id=<?= $colisItem['id'] ?>" class="btn btn-warning btn-sm">Modifier</a>
                    <a href="supprimer_colis.php?id=<?= $colisItem['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ce colis ?')">Supprimer</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <?php else: ?>
        <div class="alert alert-info">Aucun colis trouvé.</div>
    <?php endif; ?>

</div>
</body>
</html>
