<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Delivery - Plateforme de Suivi de Colis</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            color: var(--dark-color);
        }
        
        .hero-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            text-align: center;
        }
        
        .logo {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }
        
        .logo i {
            font-size: 3.5rem;
        }
        
        .hero-title {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--dark-color);
        }
        
        .hero-subtitle {
            font-size: 1.2rem;
            color: #555;
            margin-bottom: 40px;
            max-width: 700px;
        }
        
        .action-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            width: 100%;
            max-width: 1200px;
            margin-top: 50px;
        }
        
        .action-card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            padding: 30px;
            transition: all 0.3s ease;
            text-align: center;
        }
        
        .action-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
        }
        
        .action-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
        }
        
        .action-icon.login {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
        }
        
        .action-icon.register {
            background: linear-gradient(to right, var(--success-color), #3a9a33);
        }
        
        .action-icon.track {
            background: linear-gradient(to right, var(--accent-color), #3aa8d8);
        }
        
        .action-icon.reclamation {
            background: linear-gradient(to right, #ff7b25, #ff5200);
        }
        
        .action-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .action-description {
            color: #666;
            margin-bottom: 25px;
            font-size: 0.95rem;
        }
        
        .action-btn {
            display: inline-block;
            padding: 12px 25px;
            border-radius: var(--border-radius);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-login {
            background: var(--primary-color);
            color: white;
        }
        
        .btn-login:hover {
            background: var(--secondary-color);
        }
        
        .btn-register {
            background: var(--success-color);
            color: white;
        }
        
        .btn-register:hover {
            background: #3a9a33;
        }
        
        .btn-track {
            background: var(--accent-color);
            color: white;
        }
        
        .btn-track:hover {
            background: #3aa8d8;
        }
        
        .btn-reclamation {
            background: #ff7b25;
            color: white;
        }
        
        .btn-reclamation:hover {
            background: #ff5200;
        }
        
        .footer {
            margin-top: 80px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #777;
            font-size: 0.9rem;
        }
        
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2rem;
            }
            
            .hero-subtitle {
                font-size: 1rem;
            }
            
            .action-cards {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="hero-container">
        <div class="logo">
            <i class="fas fa-shipping-fast"></i>
            <span>My Delivery</span>
        </div>
        
        <h1 class="hero-title">Plateforme de Suivi de Colis Professionnelle</h1>
        <p class="hero-subtitle">
            Gérez et suivez vos colis en temps réel avec notre plateforme intuitive. 
            Inscrivez-vous dès maintenant pour bénéficier de tous nos services.
        </p>
        
        <div class="action-cards">
            <!-- بطاقة تسجيل الدخول -->
            <div class="action-card">
                <div class="action-icon login">
                    <i class="fas fa-sign-in-alt"></i>
                </div>
                <h3 class="action-title">Connexion</h3>
                <p class="action-description">
                    Accédez à votre espace client pour gérer vos colis et suivre vos expéditions.
                </p>
                <a href="login.php" class="action-btn btn-login">
                    <i class="fas fa-sign-in-alt"></i> Se Connecter
                </a>
            </div>
            
            <!-- بطاقة التسجيل -->
            <div class="action-card">
                <div class="action-icon register">
                    <i class="fas fa-user-plus"></i>
                </div>
                <h3 class="action-title">Inscription</h3>
                <p class="action-description">
                    Créez un compte gratuitement pour commencer à utiliser nos services de suivi.
                </p>
                <a href="register.php" class="action-btn btn-register">
                    <i class="fas fa-user-plus"></i> S'inscrire
                </a>
            </div>
            
            <!-- بطاقة تتبع الطرود -->
            <div class="action-card">
                <div class="action-icon track">
                    <i class="fas fa-search"></i>
                </div>
                <h3 class="action-title">Suivi de Colis</h3>
                <p class="action-description">
                    Suivez l'état de votre colis en entrant son numéro de suivi unique.
                </p>
                <a href="chercher_colis.php" class="action-btn btn-track">
                    <i class="fas fa-search"></i> Suivre un Colis
                </a>
            </div>
            
            <!-- بطاقة الشكايات -->
            <div class="action-card">
                <div class="action-icon reclamation">
                    <i class="fas fa-headset"></i>
                </div>
                <h3 class="action-title">Service Client</h3>
                <p class="action-description">
                    Déposez une réclamation ou contactez notre service client pour toute assistance.
                </p>
                <a href="reclamation.php" class="action-btn btn-reclamation">
                    <i class="fas fa-headset"></i> Déposer une Réclamation
                </a>
            </div>
        </div>
        
        <div class="footer">
            &copy; 2025 My Delivery. Tous droits réservés.Powered By: Maroc4web.com
        </div>
    </div>
</body>
</html>