<?php
session_start();
require 'db.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    die("يجب تسجيل الدخول أولاً");
}

// التحقق من وجود الطرود المحددة في الجلسة
if (!isset($_SESSION['selected_colis_for_print']) || empty($_SESSION['selected_colis_for_print'])) {
    die("لم يتم تحديد أي طرود للطباعة");
}

// جلب معلومات جميع الطرود المحددة
$placeholders = implode(',', array_fill(0, count($_SESSION['selected_colis_for_print']), '?'));
$stmt = $pdo->prepare("SELECT * FROM colis WHERE id IN ($placeholders) AND user_id = ? ORDER BY id DESC");
$params = array_merge($_SESSION['selected_colis_for_print'], [$_SESSION['user']['id']]);
$stmt->execute($params);
$all_colis = $stmt->fetchAll();

if (empty($all_colis)) {
    die("الطرود غير موجودة أو لا يوجد لديك صلاحية لعرضها");
}

// دالة لعرض البيانات بشكل آمن
function displaySafe($value, $default = '') {
    return !empty($value) ? htmlspecialchars($value) : $default;
}

// إنشاء QR Codes لجميع الطرود
require_once 'phpqrcode/qrlib.php';
$tempDir = 'temp_qrcodes/';
if (!file_exists($tempDir)) {
    mkdir($tempDir, 0755, true);
}

$qrFiles = [];
foreach ($all_colis as $colis) {
    $tracking_number = $colis['num_colis'] ?? $colis['id'];
    $tracking_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]/liv/chercher_colis.php?num_colis=" . urlencode($tracking_number);
    $qrCodeFile = $tempDir . 'qrcode_' . $colis['id'] . '.png';
    QRcode::png($tracking_url, $qrCodeFile, QR_ECLEVEL_L, 5);
    $qrFiles[$colis['id']] = $qrCodeFile;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Étiquettes de Colis Multiples</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 0;
            padding: 0;
        }
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 10mm;
            width: 210mm;
        }
        .etiquettes-container {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10mm;
            margin: 0 auto;
        }
        .etiquette {
            width: 100mm;
            height: 85mm;
            display: grid;
            grid-template-columns: 25mm auto 25mm;
            grid-template-rows: auto 1fr auto;
            gap: 1mm;
            padding: 2mm;
            box-sizing: border-box;
            border: 1px solid #000;
            page-break-inside: avoid;
        }
        .qr-container {
            grid-column: 1;
            grid-row: 1;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            justify-content: flex-start;
        }
        .logo-container {
            grid-column: 3;
            grid-row: 1;
            display: flex;
            justify-content: flex-end;
            align-items: flex-start;
        }
        .logo {
            height: 15mm;
            max-width: 25mm;
        }
        .qr-code {
            width: 20mm;
            height: 20mm;
            border: 1px solid #ddd;
        }
        .seller-info {
            grid-column: 2;
            grid-row: 1;
        }
        .recipient-info {
            grid-column: 1 / span 3;
            grid-row: 2;
        }
        .footer-info {
            grid-column: 1 / span 3;
            grid-row: 3;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 8pt;
        }
        td {
            padding: 1mm;
            border: 1px solid #000;
        }
        .label {
            font-weight: bold;
            width: 25%;
        }
        .reference {
            text-align: center;
            font-weight: bold;
            margin: 1mm 0;
            font-size: 9pt;
        }
        .footer-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 2mm;
        }
        .footer-table td {
            padding: 1mm;
            border: 1px solid #000;
            font-size: 9pt;
        }
        .footer-label {
            font-weight: bold;
            width: 50%;
        }
        .note {
            text-align: center;
            font-size: 7pt;
            font-style: italic;
            margin-top: 2mm;
        }
        .date {
            text-align: right;
            font-size: 7pt;
            margin-bottom: 1mm;
        }
        .print-btn {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 10px 20px;
            background: #0066cc;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            z-index: 1000;
        }
        .page-break {
            page-break-after: always;
        }
        @media print {
            body, html {
                margin: 0 !important;
                padding: 0 !important;
            }
            .etiquettes-container {
                grid-template-columns: repeat(2, 1fr);
                gap: 0;
                margin: 0;
            }
            .etiquette {
                margin: 0 !important;
                page-break-inside: avoid;
            }
            .print-btn {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <div class="etiquettes-container">
        <?php foreach ($all_colis as $index => $colis): ?>
            <?php 
                // تحديد حالة فتح الطرد
                $ouvertureStatus = isset($colis['autoriser_ouverture']) ? 
                                  ($colis['autoriser_ouverture'] ? 'Oui' : 'Non') : 
                                  'Non spécifié';
                $tracking_number = $colis['num_colis'] ?? $colis['id'];
            ?>
            <div class="etiquette">
                <div class="qr-container">
                    <?php if (file_exists($qrFiles[$colis['id']])): ?>
                        <img src="<?= $qrFiles[$colis['id']] ?>" class="qr-code" alt="QR Code">
                        <div style="font-size: 6pt;"><?= displaySafe($tracking_number) ?></div>
                    <?php else: ?>
                        <div style="color: red; font-size: 6pt;">QR Code Error</div>
                    <?php endif; ?>
                </div>

                <div class="logo-container">
                    <img src="logo.png" class="logo" alt="Company Logo">
                </div>

                <div class="seller-info">
                    <div class="date"><?= date('Y-m-d H:i') ?></div>
                    <table>
                        <tr>
                            <td class="label">Vendeur:</td>
                            <td><?= displaySafe($_SESSION['user']['nom'] ?? '', 'N/A') ?></td>
                        </tr>
                        <tr>
                            <td class="label">Téléphone:</td>
                            <td><?= displaySafe($_SESSION['user']['telephone'] ?? '', 'N/A') ?></td>
                        </tr>
                    </table>
                </div>

                <div class="recipient-info" style="display: flex; justify-content: space-between;">
                    <!-- معلومات المستلم في الجهة اليمنى -->
                    <div style="flex: 1;">
                        <table>
                            <tr>
                                <td class="label">Destinataire:</td>
                                <td><?= displaySafe(trim($colis['prenom'] . ' ' . $colis['nom']), 'Non spécifié') ?></td>
                            </tr>
                            <tr>
                                <td class="label">Téléphone:</td>
                                <td><?= displaySafe($colis['telephone'], 'Non spécifié') ?></td>
                            </tr>
                            <tr>
                                <td class="label">Ville:</td>
                                <td><?= displaySafe($colis['ville'], 'Non spécifié') ?></td>
                            </tr>
                            <tr>
                                <td class="label">Adresse:</td>
                                <td><?= displaySafe($colis['adresse'], 'Non spécifié') ?></td>
                            </tr>
                        </table>
                    </div>

                    <!-- جدول PR/INJ بجانب المستلم -->
                    <div style="margin-left: 5mm;">
                        <table style="font-size:6pt; border:1px solid #000; border-collapse: collapse;">
                            <tr>
                                <td style="border:1px solid #000;">PR</td>
                                <td style="border:1px solid #000; width:10mm;"></td>
                                <td style="border:1px solid #000; width:10mm;"></td>
                            </tr>
                            <tr>
                                <td style="border:1px solid #000;">INJ</td>
                                <td style="border:1px solid #000;"></td>
                                <td style="border:1px solid #000;"></td>
                            </tr>
                            <tr>
                                <td style="border:1px solid #000;">RP</td>
                                <td style="border:1px solid #000;"></td>
                                <td style="border:1px solid #000;"></td>
                            </tr>
                            <tr>
                                <td style="border:1px solid #000;">AN</td>
                                <td style="border:1px solid #000;"></td>
                                <td style="border:1px solid #000;"></td>
                            </tr>
                            <tr>
                                <td colspan="3" style="border:1px solid #000; background:#000; color:#fff; text-align:center; font-weight:bold;">
                                    HUB <?= strtoupper(displaySafe($colis['ville'], '')) ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="footer-info">
                    <div class="reference">Référence: <?= displaySafe($tracking_number, 'N/A') ?></div>
                    <table class="footer-table">
                        <tr>
                            <td class="footer-label">Crbt:</td>
                            <td><?= displaySafe($colis['montant'] ?? '0', '0') ?> DH</td>
                        </tr>
                        <tr>
                            <td class="footer-label">Autorisé d'ouvrir le colis:</td>
                            <td><?= $ouvertureStatus ?></td>
                        </tr>
                        <?php if (!empty($colis['commentaire'])): ?>
                        <tr>
                            <td class="footer-label">Commentaire:</td>
                            <td><?= displaySafe($colis['commentaire']) ?></td>
                        </tr>
                        <?php endif; ?>
                    </table>
                    <div class="note">ملحوظة : نحن شركة مكلفة بالتوصيل فقط</div>
                </div>
            </div>

            <?php 
                // إضافة فاصل صفحة بعد كل ملصقين (لطباعة أكثر من صفحة)
                if (($index + 1) % 2 == 0 && ($index + 1) < count($all_colis)) {
                    echo '<div class="page-break"></div>';
                }
            ?>
        <?php endforeach; ?>
    </div>

    <button onclick="window.print()" class="print-btn">Imprimer Toutes les Étiquettes</button>

    <script>
        // طباعة تلقائية عند تحميل الصفحة
        window.onload = function() {
            setTimeout(function() {
                window.print();
                // إغلاق النافذة بعد الطباعة (اختياري)
                setTimeout(function() {
                    window.close();
                }, 1000);
            }, 500);
        };

        function beforePrint() {
            document.body.style.margin = '0';
            document.body.style.padding = '0';
        }

        function afterPrint() {}

        window.onbeforeprint = beforePrint;
        window.onafterprint = afterPrint;
    </script>
</body>
</html>