<?php
session_start();
require 'db.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    die("يجب تسجيل الدخول أولاً");
}

// التحقق من وجود الطرود المحددة في الجلسة
if (!isset($_SESSION['selected_colis_for_print']) || empty($_SESSION['selected_colis_for_print'])) {
    die("لم يتم تحديد أي طرود للطباعة");
}

// جلب معلومات المستخدم
$user_stmt = $pdo->prepare("SELECT nom, telephone FROM users WHERE id = ?");
$user_stmt->execute([$_SESSION['user']['id']]);
$user = $user_stmt->fetch();

// جلب معلومات جميع الطرود المحددة
$placeholders = implode(',', array_fill(0, count($_SESSION['selected_colis_for_print']), '?'));
$stmt = $pdo->prepare("SELECT id, num_colis, telephone, ville, montant FROM colis WHERE id IN ($placeholders) AND user_id = ? ORDER BY id DESC");
$params = array_merge($_SESSION['selected_colis_for_print'], [$_SESSION['user']['id']]);
$stmt->execute($params);
$all_colis = $stmt->fetchAll();

if (empty($all_colis)) {
    die("الطرود غير موجودة أو لا يوجد لديك صلاحية لعرضها");
}

// حساب المجموع الكلي
$total = array_sum(array_column($all_colis, 'montant'));

// إنشاء رقم بون ليفراسون عشوائي
$bon_number = 'BL-' . strtoupper(substr(md5(uniqid()), 0, 8));
$current_date = date('d/m/Y');
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bon de Livraison - <?= $bon_number ?></title>
    <style>
        @page {
            size: A4 portrait;
            margin: 10mm;
        }
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 10mm;
        }
        .header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15mm;
        }
        .logo-container {
            width: 40%;
        }
        .logo {
            max-height: 50mm;
            max-width: 100%;
        }
        .user-info {
            border: 1px solid #000;
            padding: 3mm;
            margin-top: 3mm;
            font-size: 10pt;
        }
        .user-info p {
            margin: 2mm 0;
        }
        .bon-info {
            width: 50%;
            border: 1px solid #000;
            padding: 3mm;
            font-size: 10pt;
        }
        .bon-info h2 {
            text-align: center;
            margin-top: 0;
            color: #333;
        }
        .bon-info p {
            margin: 2mm 0;
            display: flex;
            justify-content: space-between;
        }
        .bon-info .label {
            font-weight: bold;
        }
        .table-container {
            margin-top: 5mm;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5mm;
        }
        th, td {
            border: 1px solid #000;
            padding: 2mm;
            text-align: left;
            font-size: 9pt;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .total-row {
            font-weight: bold;
            background-color: #f2f2f2;
        }
        .footer {
            margin-top: 10mm;
            display: flex;
            justify-content: space-between;
            font-size: 9pt;
        }
        .signature {
            width: 40%;
            text-align: center;
            margin-top: 15mm;
        }
        .signature-line {
            border-top: 1px solid #000;
            width: 80%;
            margin: 5mm auto;
        }
        .print-btn {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 10px 20px;
            background: #0066cc;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            z-index: 1000;
        }
        @media print {
            .print-btn {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo-container">
            <img src="logo.png" class="logo" alt="Company Logo">
            <div class="user-info">
                <p><strong>Vendeur:</strong> <?= htmlspecialchars($user['nom'] ?? 'N/A') ?></p>
                <p><strong>Téléphone:</strong> <?= htmlspecialchars($user['telephone'] ?? 'N/A') ?></p>
            </div>
        </div>
        
        <div class="bon-info">
            <h2>Bon de Livraison</h2>
            <p><span class="label">N°:</span> <span><?= $bon_number ?></span></p>
            <p><span class="label">Date:</span> <span><?= $current_date ?></span></p>
            <p><span class="label">Colis:</span> <span><?= count($all_colis) ?></span></p>
            <p><span class="label">Total:</span> <span><?= number_format($total, 2) ?> DH</span></p>
        </div>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th width="5%">N°</th>
                    <th width="25%">Numéro de Colis</th>
                    <th width="20%">Téléphone</th>
                    <th width="20%">Ville</th>
                    <th width="15%">Montant</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($all_colis as $index => $colis): ?>
                <tr>
                    <td><?= $index + 1 ?></td>
                    <td><?= htmlspecialchars($colis['num_colis'] ?? $colis['id']) ?></td>
                    <td><?= htmlspecialchars($colis['telephone']) ?></td>
                    <td><?= htmlspecialchars($colis['ville']) ?></td>
                    <td><?= number_format($colis['montant'], 2) ?> DH</td>
                </tr>
                <?php endforeach; ?>
                <tr class="total-row">
                    <td colspan="4" style="text-align: right;"><strong>Total:</strong></td>
                    <td><strong><?= number_format($total, 2) ?> DH</strong></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="footer">
        <div style="width: 60%;">
            <p><strong>Note:</strong> Merci de vérifier les colis avant signature.</p>
        </div>
        <div class="signature">
            <p>Signature du client</p>
            <div class="signature-line"></div>
        </div>
    </div>

    <button onclick="window.print()" class="print-btn">Imprimer</button>

    <script>
        // طباعة تلقائية عند تحميل الصفحة
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>