<?php
header('Content-Type: application/json');
require 'db.php';

// التحقق من وجود رقم التتبع
if (!isset($_GET['numero_colis'])) {
    echo json_encode(['error' => 'Numéro de colis manquant']);
    exit();
}

$numeroColis = $_GET['numero_colis'];

try {
    // الاتصال بقاعدة البيانات
    $stmt = $pdo->prepare("SELECT statut, date_mise_a_jour FROM colis WHERE num_colis = ?");
    $stmt->execute([$numeroColis]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        echo json_encode([
            'statut' => $result['statut'],
            'last_update' => $result['date_mise_a_jour'] ?? date('Y-m-d H:i:s')
        ]);
    } else {
        echo json_encode(['error' => 'Colis non trouvé']);
    }
} catch (PDOException $e) {
    echo json_encode(['error' => 'Erreur de base de données: ' . $e->getMessage()]);
}
?>