<?php
session_start();
require 'db.php';
require_once('tcpdf/tcpdf.php');

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "يجب تسجيل الدخول أولاً";
    header('Location: login.php');
    exit();
}

// جلب بيانات الطرد
$package_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$stmt = $pdo->prepare("SELECT * FROM colis WHERE id = ? AND user_id = ?");
$stmt->execute([$package_id, $_SESSION['user']['id']]);
$package = $stmt->fetch();

if (!$package) {
    die("Colis non trouvé ou non autorisé");
}

// إنشاء رابط QR Code
$qr_url = "https://votre-site.com/chercher_colis.php?num_colis=" . urlencode($package['num_colis']);

// دالة إنشاء PDF
function generatePDF($package, $qr_url) {
    // إنشاء كائن PDF جديد
    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
    
    // إعدادات المستند
    $pdf->SetCreator('My Delivery');
    $pdf->SetAuthor('My Delivery');
    $pdf->SetTitle('Facture #' . $package['num_colis']);
    $pdf->SetMargins(15, 15, 15);
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(0);
    $pdf->AddPage();

    // HTML للفاتورة
    $html = '
    <style>
        .header { display: flex; justify-content: space-between; margin-bottom: 15px; }
        .title { font-size: 18pt; font-weight: bold; color: #2c3e50; }
        .client-info { margin-bottom: 15px; line-height: 1.5; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 15px; }
        th { background-color: #f2f2f2; border: 1px solid #000; padding: 5px; font-weight: bold; }
        td { border: 1px solid #000; padding: 5px; }
        .totals { width: 50%; margin-left: auto; }
        .footer { margin-top: 15px; font-style: italic; text-align: center; }
        .qr-code { border: 1px solid #000; padding: 3px; }
    </style>
    
    <div class="header">
        <h1 class="title">MY DELIVERY</h1>
        <div class="qr-code">
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=' . urlencode($qr_url) . '" width="80">
        </div>
    </div>
    
    <div class="client-info">
        <p><strong>Nom de client:</strong> ' . htmlspecialchars($package['nom'] . ' ' . $package['prenom']) . '</p>
        <p><strong>Téléphone:</strong> ' . htmlspecialchars($package['telephone']) . '</p>
        <p><strong>Compte Bancaire:</strong> ' . (isset($package['account_number']) ? htmlspecialchars($package['account_number']) : 'N/A') . '</p>
    </div>
    
    <table>
        <tr>
            <th width="5%">N°</th>
            <th width="15%">Colis</th>
            <th width="10%">Montant</th>
            <th width="12%">Date</th>
            <th width="12%">Statut</th>
            <th width="12%">Ville</th>
            <th width="12%">Paiement</th>
            <th width="12%">Frais</th>
            <th width="10%">Total</th>
        </tr>
        <tr>
            <td>1</td>
            <td>' . htmlspecialchars($package['num_colis'] ?? '-') . '</td>
            <td>' . number_format($package['montant'], 2) . ' DH</td>
            <td>' . htmlspecialchars($package['date_livraison'] ?? date('d/m/Y')) . '</td>
            <td>' . htmlspecialchars($package['statut']) . '</td>
            <td>' . htmlspecialchars($package['ville']) . '</td>
            <td>' . htmlspecialchars($package['reglement']) . '</td>
            <td>' . number_format($package['frais_livraison'] ?? 0, 2) . ' DH</td>
            <td>' . number_format($package['montant'] + ($package['frais_livraison'] ?? 0), 2) . ' DH</td>
        </tr>
    </table>
    
    <table class="totals">
        <tr>
            <td width="60%"><strong>Total Colis</strong></td>
            <td width="40%">' . number_format($package['montant'], 2) . ' DH</td>
        </tr>
        <tr>
            <td><strong>Frais Livraison</strong></td>
            <td>' . number_format($package['frais_livraison'] ?? 0, 2) . ' DH</td>
        </tr>
        <tr>
            <td><strong>Total Net</strong></td>
            <td>' . number_format($package['montant'] + ($package['frais_livraison'] ?? 0), 2) . ' DH</td>
        </tr>
    </table>
    
    <div class="footer">
        <p><strong>Sauf Erreur Ou Omission</strong></p>
        <p>Merci pour votre confiance</p>
    </div>';

    // كتابة المحتوى إلى PDF
    $pdf->writeHTML($html, true, false, true, false, '');
    
    // إخراج ملف PDF للتحميل
    $pdf->Output('facture_' . $package['num_colis'] . '.pdf', 'D');
}

// تحميل PDF إذا طُلب
if (isset($_GET['download_pdf'])) {
    generatePDF($package, $qr_url);
    exit();
}

// عرض HTML
$auto_print = isset($_GET['print']) && $_GET['print'] == 'true';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facture de Livraison</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 20px; background: #f5f5f5; }
        .invoice-container { max-width: 210mm; margin: 0 auto; background: #fff; padding: 15mm; box-shadow: 0 0 10px rgba(0,0,0,0.1); border: 1px solid #000; }
        .invoice-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #000; }
        .invoice-title { font-size: 24px; margin: 0; color: #2c3e50; font-weight: bold; }
        .client-info { margin-bottom: 20px; line-height: 1.5; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th { background: #f2f2f2; border: 1px solid #000; padding: 8px; text-align: left; }
        td { border: 1px solid #000; padding: 8px; }
        .totals-table { width: 50%; margin-left: auto; border-collapse: collapse; }
        .totals-table td { border: 1px solid #000; padding: 8px; }
        .totals-table td:first-child { font-weight: bold; background: #f2f2f2; }
        .footer-note { margin-top: 20px; text-align: center; font-style: italic; border-top: 1px solid #000; padding-top: 10px; }
        .action-buttons { text-align: right; margin-bottom: 15px; }
        .btn { display: inline-block; padding: 8px 15px; background: #3498db; color: #fff; text-decoration: none; border-radius: 4px; margin-left: 10px; font-size: 14px; }
        .btn-pdf { background: #e74c3c; }
        .qr-container { border: 1px solid #000; padding: 5px; display: inline-block; }
        @media print {
            body { background: none; padding: 0; }
            .action-buttons { display: none; }
            .invoice-container { box-shadow: none; border: none; padding: 0; margin: 0; width: 100%; }
        }
    </style>
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body onload="<?= $auto_print ? 'window.print();' : '' ?>">
    <div class="invoice-container">
        <div class="action-buttons">
            <a href="facture.php?id=<?= $package_id ?>&download_pdf=1" class="btn btn-pdf">
                <i class="fas fa-download"></i> Télécharger PDF
            </a>
            <a href="facture.php?id=<?= $package_id ?>&print=true" class="btn" target="_blank">
                <i class="fas fa-print"></i> Imprimer
            </a>
        </div>
        
        <div class="invoice-header">
            <h1 class="invoice-title">MY DELIVERY</h1>
            <div class="qr-container" id="qrcode"></div>
        </div>
        
        <div class="client-info">
            <p><strong>Nom de client :</strong> <?= htmlspecialchars($package['nom'] . ' ' . $package['prenom']) ?></p>
            <p><strong>Téléphone :</strong> <?= htmlspecialchars($package['telephone']) ?></p>
            <p><strong>Numéro du compte Bancaire :</strong> <?= isset($package['account_number']) ? htmlspecialchars($package['account_number']) : 'N/A' ?></p>
        </div>
        
        <table>
            <tr>
                <th width="5%">N°</th>
                <th width="15%">Num de colis</th>
                <th width="10%">Montant</th>
                <th width="12%">Date de livraison</th>
                <th width="12%">Status</th>
                <th width="12%">Ville</th>
                <th width="12%">Règlement</th>
                <th width="12%">Frais de livraison</th>
                <th width="10%">Total</th>
            </tr>
            <tr>
                <td>1</td>
                <td><?= htmlspecialchars($package['num_colis'] ?? '-') ?></td>
                <td><?= number_format($package['montant'], 2) ?> DH</td>
                <td><?= htmlspecialchars($package['date_livraison'] ?? date('d/m/Y')) ?></td>
                <td><?= htmlspecialchars($package['statut']) ?></td>
                <td><?= htmlspecialchars($package['ville']) ?></td>
                <td><?= htmlspecialchars($package['reglement']) ?></td>
                <td><?= number_format($package['frais_livraison'] ?? 0, 2) ?> DH</td>
                <td><?= number_format($package['montant'] + ($package['frais_livraison'] ?? 0), 2) ?> DH</td>
            </tr>
        </table>
        
        <table class="totals-table">
            <tr>
                <td width="60%"><strong>Total Colis</strong></td>
                <td width="40%"><?= number_format($package['montant'], 2) ?> DH</td>
            </tr>
            <tr>
                <td><strong>Total Frais de livraison</strong></td>
                <td><?= number_format($package['frais_livraison'] ?? 0, 2) ?> DH</td>
            </tr>
            <tr>
                <td><strong>Total Net</strong></td>
                <td><?= number_format($package['montant'] + ($package['frais_livraison'] ?? 0), 2) ?> DH</td>
            </tr>
        </table>
        
        <div class="footer-note">
            <p><strong>Sauf Erreur Ou Omission</strong></p>
            <p>Merci pour votre confiance</p>
        </div>
    </div>

    <script>
        new QRCode(document.getElementById("qrcode"), {
            text: "<?= $qr_url ?>",
            width: 100,
            height: 100,
            colorDark: "#000000",
            colorLight: "#ffffff"
        });
    </script>
</body>
</html>