<?php
session_start();
require 'db.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "يجب تسجيل الدخول أولاً";
    header('Location: login.php');
    exit();
}

// جلب إحصائيات الطرود
$stmt = $pdo->prepare("SELECT 
    COUNT(*) as total_colis,
    SUM(montant) as total_montant,
    SUM(CASE WHEN statut = 'en attente' THEN 1 ELSE 0 END) as en_attente,
    SUM(CASE WHEN statut = 'livré' THEN 1 ELSE 0 END) as livre,
    SUM(CASE WHEN statut = 'annulé' THEN 1 ELSE 0 END) as annule
    FROM colis WHERE user_id = ?");

$stmt->execute([$_SESSION['user']['id']]);
$stats = $stmt->fetch();

// جلب آخر 5 طرود مضافة
$stmt = $pdo->prepare("SELECT * FROM colis WHERE user_id = ? ORDER BY id DESC LIMIT 5");
$stmt->execute([$_SESSION['user']['id']]);
$recent_colis = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tableau de Bord - Plateforme Client</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
            color: var(--dark-color);
        }
        
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background: white;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            padding: 20px 0;
        }
        
        .sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        
        .sidebar-logo {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--primary-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
        }
        
        .sidebar-menu li a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #555;
            text-decoration: none;
            transition: all 0.3s ease;
            gap: 10px;
        }
        
        .sidebar-menu li a:hover, 
        .sidebar-menu li a.active {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            border-left: 3px solid var(--primary-color);
        }
        
        .sidebar-menu li a i {
            width: 20px;
            text-align: center;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
            background: #f5f7fa;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .page-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: var(--dark-color);
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            padding: 20px;
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }
        
        .stat-card.primary {
            border-top: 4px solid var(--primary-color);
        }
        
        .stat-card.success {
            border-top: 4px solid var(--success-color);
        }
        
        .stat-card.warning {
            border-top: 4px solid var(--warning-color);
        }
        
        .stat-card.danger {
            border-top: 4px solid var(--error-color);
        }
        
        .stat-title {
            font-size: 0.9rem;
            color: #777;
            margin-bottom: 10px;
        }
        
        .stat-value {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 15px;
        }
        
        .stat-icon.primary {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
        }
        
        .stat-icon.success {
            background: rgba(75, 181, 67, 0.1);
            color: var(--success-color);
        }
        
        .stat-icon.warning {
            background: rgba(248, 210, 16, 0.1);
            color: var(--warning-color);
        }
        
        .stat-icon.danger {
            background: rgba(255, 51, 51, 0.1);
            color: var(--error-color);
        }
        
        .recent-colis {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            padding: 20px;
        }
        
        .section-title {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .colis-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .colis-table th {
            text-align: left;
            padding: 12px 15px;
            background: #f8f9fa;
            font-weight: 500;
        }
        
        .colis-table td {
            padding: 12px 15px;
            border-bottom: 1px solid #eee;
        }
        
        .colis-table tr:last-child td {
            border-bottom: none;
        }
        
        .status-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .status-pending {
            background: rgba(248, 210, 16, 0.2);
            color: #b38f00;
        }
        
        .status-delivered {
            background: rgba(75, 181, 67, 0.2);
            color: var(--success-color);
        }
        
        .status-cancelled {
            background: rgba(255, 51, 51, 0.2);
            color: var(--error-color);
        }
        
        .view-all {
            display: inline-block;
            margin-top: 15px;
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        
        .view-all:hover {
            text-decoration: underline;
        }
        
        @media (max-width: 992px) {
            .dashboard-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
                height: auto;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- القائمة الجانبية -->
        <div class="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <i class="fas fa-box-open"></i>
                    <span>My Delivery</span>
                </div>
            </div>
            <ul class="sidebar-menu">
                <li><a href="dashboard.php" class="active"><i class="fas fa-tachometer-alt"></i> Tableau de board</a></li>
                <li><a href="liste_colis.php"><i class="fas fa-boxes"></i> Liste Colis</a></li>
                <li><a href="ajouter_colis.php"><i class="fas fa-plus-circle"></i> Ajouter un colis</a></li>
                <li><a href="profile.php"><i class="fas fa-user"></i> Profile</a></li>
            </ul>
        </div>
        
        <!-- المحتوى الرئيسي -->
        <div class="main-content">
            <div class="page-header">
                <h1 class="page-title"><i class="fas fa-tachometer-alt"></i> Tableau de Bord</h1>
            </div>
            
            <!-- بطاقات الإحصائيات -->
            <div class="stats-grid">
                <div class="stat-card primary">
                    <div class="stat-icon primary">
                        <i class="fas fa-boxes"></i>
                    </div>
                    <div class="stat-title">Total des Colis</div>
                    <div class="stat-value"><?= $stats['total_colis'] ?? 0 ?></div>
                </div>
                
                <div class="stat-card success">
                    <div class="stat-icon success">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="stat-title">Montant Total</div>
                    <div class="stat-value"><?= number_format($stats['total_montant'] ?? 0, 2) ?> DH</div>
                </div>
                
                <div class="stat-card warning">
                    <div class="stat-icon warning">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stat-title">En Attente</div>
                    <div class="stat-value"><?= $stats['en_attente'] ?? 0 ?></div>
                </div>
                
                <div class="stat-card danger">
                    <div class="stat-icon danger">
                        <i class="fas fa-times-circle"></i>
                    </div>
                    <div class="stat-title">Annulés</div>
                    <div class="stat-value"><?= $stats['annule'] ?? 0 ?></div>
                </div>
            </div>
            
            <!-- آخر الطرود المضافة -->
            <div class="recent-colis">
                <h3 class="section-title">
                    <i class="fas fa-history"></i> Derniers Colis Ajoutés
                </h3>
                
                <?php if (!empty($recent_colis)): ?>
                <table class="colis-table">
                    <thead>
                        <tr>
                            <th>Numéro</th>
                            <th>Destinataire</th>
                            <th>Ville</th>
                            <th>Montant</th>
                            <th>Statut</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($recent_colis as $colis): ?>
                        <tr>
                            <td><?= $colis['num_colis'] ?? '-' ?></td>
                            <td><?= htmlspecialchars($colis['nom']) ?> <?= htmlspecialchars($colis['prenom']) ?></td>
                            <td><?= htmlspecialchars($colis['ville']) ?></td>
                            <td><?= htmlspecialchars($colis['montant']) ?> DH</td>
                            <td>
                                <span class="status-badge status-<?= str_replace(' ', '-', strtolower($colis['statut'])) ?>">
                                    <?= htmlspecialchars($colis['statut']) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
                <a href="liste_colis.php" class="view-all">
                    <i class="fas fa-list"></i> Voir tous les colis
                </a>
                <?php else: ?>
                    <p>Aucun colis trouvé.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>