<?php
session_start();
require 'db.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "يجب تسجيل الدخول أولاً";
    header('Location: login.php');
    exit();
}

// تنفيذ البحث والفلاتر
$recherche = $_GET['recherche'] ?? '';
$filtre = $_GET['filtre'] ?? '';

// قاعدة الاستعلام
$sql = "SELECT c.* FROM colis c
        INNER JOIN users u ON c.user_id = u.id
        WHERE c.user_id = ?
        AND u.statut = 'actif'";

// إضافة شروط البحث إن وُجد
$params = [$_SESSION['user']['id']];

if (!empty($recherche)) {
    $sql .= " AND (c.nom LIKE ? OR c.prenom LIKE ? OR c.ville LIKE ?)";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
}

if (!empty($filtre)) {
    $sql .= " AND c.statut = ?";
    $params[] = $filtre;
}

$sql .= " ORDER BY c.id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$colis = $stmt->fetchAll();

// دالة لحساب تكاليف التوصيل حسب المدينة (تم التعديل لجلبها من قاعدة البيانات)
function getFraisLivraison($pdo, $ville) {
    try {
        $stmt = $pdo->prepare("SELECT frais_livraison FROM villes WHERE nom_ville = ?");
        $stmt->execute([$ville]);
        $result = $stmt->fetch();
        
        return $result ? $result['frais_livraison'] : 20; // سعر افتراضي إذا لم تكن المدينة موجودة
    } catch (PDOException $e) {
        // في حالة حدوث خطأ، نعود للسعر الافتراضي
        error_log("Erreur lors de la récupération des frais de livraison: " . $e->getMessage());
        return 20;
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Liste des Colis - Plateforme Client</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        * {margin:0;padding:0;box-sizing:border-box;}
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
            color: var(--dark-color);
        }
        .dashboard-container {display:flex;min-height:100vh;}
        .sidebar {width:250px;background:white;box-shadow:2px 0 10px rgba(0,0,0,0.1);padding:20px 0;}
        .sidebar-header {padding:0 20px 20px;border-bottom:1px solid #eee;margin-bottom:20px;}
        .sidebar-logo {font-size:1.5rem;font-weight:600;color:var(--primary-color);display:flex;align-items:center;gap:10px;}
        .sidebar-menu {list-style:none;}
        .sidebar-menu li a {display:flex;align-items:center;padding:12px 20px;color:#555;text-decoration:none;transition:all 0.3s ease;gap:10px;}
        .sidebar-menu li a:hover,.sidebar-menu li a.active {background:rgba(67,97,238,0.1);color:var(--primary-color);border-left:3px solid var(--primary-color);}
        .sidebar-menu li a i {width:20px;text-align:center;}
        .main-content {flex:1;padding:30px;background:#f5f7fa;}
        .page-header {display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;}
        .page-title {font-size:1.8rem;font-weight:600;color:var(--dark-color);}
        .search-filter-container {background:white;padding:20px;border-radius:var(--border-radius);box-shadow:var(--box-shadow);margin-bottom:30px;}
        .search-form {display:flex;gap:10px;}
        .search-input {flex:1;padding:10px 15px;border:1px solid #ddd;border-radius:var(--border-radius);font-size:1rem;}
        .filter-select {padding:10px 15px;border:1px solid #ddd;border-radius:var(--border-radius);font-size:1rem;min-width:200px;}
        .search-btn {background:var(--primary-color);color:white;border:none;padding:0 20px;border-radius:var(--border-radius);cursor:pointer;transition:all 0.3s ease;}
        .search-btn:hover {background:var(--secondary-color);}
        .add-btn {background:var(--success-color);color:white;border:none;padding:10px 20px;border-radius:var(--border-radius);cursor:pointer;transition:all 0.3s ease;text-decoration:none;display:inline-flex;align-items:center;gap:5px;}
        .add-btn:hover {background:#3a9a33;}
        .colis-table {width:100%;background:white;border-radius:var(--border-radius);box-shadow:var(--box-shadow);overflow:hidden;border-collapse:separate;border-spacing:0;}
        .colis-table th {background:var(--primary-color);color:white;padding:15px;text-align:left;font-weight:500;}
        .colis-table td {padding:12px 15px;border-bottom:1px solid #eee;}
        .colis-table tr:last-child td {border-bottom:none;}
        .colis-table tr:hover td {background:rgba(67,97,238,0.05);}
        .status-btn {padding:6px 12px;border-radius:20px;font-size:0.8rem;font-weight:500;border:none;cursor:default;display:inline-block;text-align:center;min-width:80px;color:white;}
        .status-delivered {background-color:var(--success-color);}
        .status-annule {background-color:var(--error-color);}
        .status-en-attente {background-color:var(--warning-color);color:#333;}
        .reglement-paye {background-color:var(--success-color);color:white;padding:6px 12px;border-radius:20px;font-size:0.8rem;display:inline-block;min-width:80px;text-align:center;}
        .reglement-en-cours {background-color:var(--warning-color);color:#333;padding:6px 12px;border-radius:20px;font-size:0.8rem;display:inline-block;min-width:80px;text-align:center;}
        .action-btn {padding:8px;border-radius:50%;font-size:0.8rem;text-decoration:none;margin-right:5px;display:inline-flex;align-items:center;justify-content:center;width:32px;height:32px;position:relative;transition:all 0.2s ease;}
        .edit-btn {background:rgba(248,210,16,0.2);color:#b38f00;}
        .edit-btn:hover {background:rgba(248,210,16,0.3);transform:scale(1.1);}
        .delete-btn {background:rgba(255,51,51,0.2);color:var(--error-color);}
        .delete-btn:hover {background:rgba(255,51,51,0.3);transform:scale(1.1);}
        .print-btn {background:rgba(67,97,238,0.2);color:var(--primary-color);}
        .print-btn:hover {background:rgba(67,97,238,0.3);transform:scale(1.1);}
        .action-btn::after {content:attr(title);position:absolute;bottom:-30px;left:50%;transform:translateX(-50%);background:var(--dark-color);color:white;padding:4px 8px;border-radius:4px;font-size:0.7rem;white-space:nowrap;opacity:0;transition:opacity 0.3s;pointer-events:none;z-index:10;}
        .action-btn:hover::after {opacity:1;}
        .no-data {text-align:center;padding:30px;background:white;border-radius:var(--border-radius);box-shadow:var(--box-shadow);}
        @media (max-width:992px){.dashboard-container{flex-direction:column;}.sidebar{width:100%;height:auto;}.search-form{flex-direction:column;}.filter-select{width:100%;}.action-btn{width:28px;height:28px;font-size:0.7rem;}.status-btn{min-width:70px;font-size:0.7rem;padding:4px 8px;}}
    </style>
</head>
<body>
    <div class="dashboard-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo"><i class="fas fa-box-open"></i><span>My Delivery</span></div>
            </div>
            <ul class="sidebar-menu">
                <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Tableau de board</a></li>
                <li><a href="liste_colis.php" class="active"><i class="fas fa-boxes"></i> Liste Colis</a></li>
                <li><a href="ajouter_colis.php"><i class="fas fa-plus-circle"></i> Ajouter un colis</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="page-header">
                <h1 class="page-title"><i class="fas fa-boxes"></i> Liste des Colis</h1>
                <a href="ajouter_colis.php" class="add-btn"><i class="fas fa-plus"></i> Ajouter un Colis</a>
            </div>

            <div class="search-filter-container">
                <form method="get" class="search-form">
                    <input type="text" name="recherche" class="search-input" placeholder="Rechercher par nom, prénom ou ville..." value="<?= htmlspecialchars($recherche) ?>">
                    <select name="filtre" class="filter-select">
                        <option value="">-- Tous les statuts --</option>
                        <?php foreach (['en attente', 'livré', 'annulé'] as $statut_option): ?>
                            <option value="<?= $statut_option ?>" <?= $filtre === $statut_option ? 'selected' : '' ?>><?= ucfirst($statut_option) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <button type="submit" class="search-btn"><i class="fas fa-search"></i> Filtrer</button>
                </form>
            </div>

            <?php if (!empty($colis)): ?>
            <div style="overflow-x:auto;">
                <table class="colis-table">
                    <thead>
                        <tr>
                            <th>Numéro de Colis</th>
                            <th>Nom</th>
                            <th>Prénom</th>
                            <th>Ville</th>
                            <th>Téléphone</th>
                            <th>Montant</th>
                            <th>Frais de livraison</th>
                            <th>Statut</th>
                            <th>Règlement</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($colis as $colisItem): ?>
                        <tr>
                            <td><?= $colisItem['num_colis'] ?? '-' ?></td>
                            <td><?= htmlspecialchars($colisItem['nom']) ?></td>
                            <td><?= htmlspecialchars($colisItem['prenom']) ?></td>
                            <td><?= htmlspecialchars($colisItem['ville']) ?></td>
                            <td><?= htmlspecialchars($colisItem['telephone']) ?></td>
                            <td><?= htmlspecialchars($colisItem['montant']) ?> DH</td>
                            <td><?= getFraisLivraison($pdo, $colisItem['ville']) ?> DH</td>
                            <td>
                                <?php
                                $statutClass = '';
                                switch(strtolower($colisItem['statut'])) {
                                    case 'livré': $statutClass = 'status-delivered'; break;
                                    case 'annulé': $statutClass = 'status-annule'; break;
                                    case 'en attente': default: $statutClass = 'status-en-attente';
                                }
                                ?>
                                <span class="status-btn <?= $statutClass ?>"><?= htmlspecialchars($colisItem['statut']) ?></span>
                            </td>
                            <td>
                                <?php if (strtolower($colisItem['reglement']) == 'payé'): ?>
                                    <span class="reglement-paye">Payé</span>
                                <?php else: ?>
                                    <span class="reglement-en-cours">En cours</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="modifier_colis.php?id=<?= $colisItem['id'] ?>" class="action-btn edit-btn" title="Modifier"><i class="fas fa-edit"></i></a>
                                <a href="supprimer_colis.php?id=<?= $colisItem['id'] ?>" class="action-btn delete-btn" title="Supprimer" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce colis ?')"><i class="fas fa-trash"></i></a>
                                <a href="imprimer_etiquette.php?id=<?= $colisItem['id'] ?>" class="action-btn print-btn" title="Imprimer" target="_blank"><i class="fas fa-print"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php else: ?>
                <div class="no-data">
                    <i class="fas fa-box-open" style="font-size:3rem;color:#ccc;margin-bottom:15px;"></i>
                    <h3>Aucun colis trouvé</h3>
                    <p>Aucun colis ne correspond à vos critères de recherche.</p>
                    <a href="ajouter_colis.php" class="add-btn"><i class="fas fa-plus"></i> Ajouter un nouveau colis</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>