<?php
require 'db.php';

$colis = null;
$message = '';

if (isset($_GET['num_colis'])) {
    $numColis = trim($_GET['num_colis']);

    if ($numColis === '') {
        $message = 'Veuillez entrer un numéro de colis.';
    } else {
        try {
            $stmt = $pdo->prepare("SELECT num_colis, statut FROM colis WHERE num_colis = ?");
            $stmt->execute([$numColis]);
            $colis = $stmt->fetch();

            if (!$colis) {
                $message = 'Aucun colis trouvé pour ce numéro.';
            }
        } catch (PDOException $e) {
            $message = "Erreur de connexion à la base de données.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suivi de Colis - TrackShip</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            padding: 40px 20px;
            color: var(--dark-color);
        }
        
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        
        header {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
        }
        
        header h1 {
            font-size: 2.2rem;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        header p {
            font-size: 1rem;
            opacity: 0.9;
        }
        
        .logo {
            font-size: 2.5rem;
            margin-bottom: 15px;
            color: var(--accent-color);
        }
        
        .search-section {
            padding: 40px;
            text-align: center;
        }
        
        .search-form {
            display: flex;
            max-width: 600px;
            margin: 0 auto;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            border-radius: 50px;
            overflow: hidden;
        }
        
        .search-input {
            flex: 1;
            padding: 15px 25px;
            border: none;
            font-size: 1rem;
            outline: none;
        }
        
        .search-btn {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            color: white;
            border: none;
            padding: 0 30px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .search-btn:hover {
            background: linear-gradient(to right, var(--secondary-color), var(--primary-color));
        }
        
        .result-section {
            padding: 0 40px 40px;
        }
        
        .message {
            text-align: center;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 500;
        }
        
        .error {
            background-color: rgba(255, 51, 51, 0.1);
            color: var(--error-color);
        }
        
        .success {
            background-color: rgba(75, 181, 67, 0.1);
            color: var(--success-color);
        }
        
        .info {
            background-color: rgba(76, 201, 240, 0.1);
            color: var(--primary-color);
        }
        
        .tracking-card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            padding: 30px;
            margin-top: 20px;
            border-left: 4px solid var(--primary-color);
        }
        
        .tracking-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        
        .tracking-number {
            font-size: 1.2rem;
            font-weight: 600;
            color: var(--primary-color);
        }
        
        .status {
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: 500;
            font-size: 0.9rem;
        }
        
        .status-pending {
            background-color: rgba(248, 210, 16, 0.2);
            color: #b38f00;
        }
        
        .status-shipped {
            background-color: rgba(67, 97, 238, 0.2);
            color: var(--primary-color);
        }
        
        .status-delivered {
            background-color: rgba(75, 181, 67, 0.2);
            color: var(--success-color);
        }
        
        .tracking-timeline {
            position: relative;
            padding-left: 30px;
            margin-top: 30px;
        }
        
        .timeline-progress {
            position: absolute;
            left: 7px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: #eee;
        }
        
        .timeline-progress-bar {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            height: 0;
            background: var(--primary-color);
            transition: height 0.6s ease;
        }
        
        .timeline-step {
            position: relative;
            padding-bottom: 30px;
        }
        
        .timeline-step:last-child {
            padding-bottom: 0;
        }
        
        .timeline-icon {
            position: absolute;
            left: -30px;
            top: 0;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background: white;
            border: 2px solid #ddd;
        }
        
        .timeline-step.active .timeline-icon {
            border-color: var(--primary-color);
            background: var(--primary-color);
        }
        
        .timeline-step.completed .timeline-icon {
            border-color: var(--success-color);
            background: var(--success-color);
        }
        
        .timeline-date {
            font-size: 0.8rem;
            color: #777;
            margin-bottom: 5px;
        }
        
        .timeline-content {
            font-size: 0.95rem;
        }
        
        .timeline-content strong {
            font-weight: 500;
            color: var(--dark-color);
        }
        
        .footer {
            text-align: center;
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #777;
            font-size: 0.9rem;
        }
        
        @media (max-width: 768px) {
            .container {
                border-radius: 10px;
            }
            
            header {
                padding: 20px;
            }
            
            header h1 {
                font-size: 1.8rem;
            }
            
            .search-section {
                padding: 30px 20px;
            }
            
            .search-form {
                flex-direction: column;
                border-radius: 8px;
            }
            
            .search-input {
                border-radius: 8px 8px 0 0;
            }
            
            .search-btn {
                padding: 15px;
                border-radius: 0 0 8px 8px;
            }
            
            .result-section {
                padding: 0 20px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <div class="logo">
                <i class="fas fa-truck"></i>
            </div>
            <h1>Suivi de Colis</h1>
            <p>Entrez votre numéro de suivi pour connaître le statut de votre colis</p>
        </header>
        
        <section class="search-section">
            <form method="GET" action="" class="search-form">
                <input type="text" name="num_colis" class="search-input" placeholder="Entrez votre numéro de suivi..." value="<?= isset($_GET['num_colis']) ? htmlspecialchars($_GET['num_colis']) : '' ?>">
                <button type="submit" class="search-btn">
                    <i class="fas fa-search"></i> Rechercher
                </button>
            </form>
        </section>
        
        <section class="result-section">
            <?php if ($message): ?>
                <div class="message <?php echo ($colis ? 'success' : 'error'); ?>">
                    <i class="fas <?php echo ($colis ? 'fa-check-circle' : 'fa-exclamation-circle'); ?>"></i>
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>
            
            <?php if ($colis): ?>
                <div class="tracking-card">
                    <div class="tracking-header">
                        <div class="tracking-number">
                            <i class="fas fa-box"></i> COLIS #<?= htmlspecialchars($colis['num_colis']) ?>
                        </div>
                        <div class="status <?php 
                            echo strtolower($colis['statut']) === 'livré' ? 'status-delivered' : 
                                 (strtolower($colis['statut']) === 'expédié' ? 'status-shipped' : 'status-pending'); 
                        ?>">
                            <?= htmlspecialchars($colis['statut']) ?>
                        </div>
                    </div>
                    
                    <div class="tracking-timeline">
                        <div class="timeline-progress">
                            <div class="timeline-progress-bar" style="height: 100%;"></div>
                        </div>
                        
                        <div class="timeline-step completed">
                            <div class="timeline-icon"></div>
                            <div class="timeline-date"><?= date('d M Y') ?></div>
                            <div class="timeline-content">
                                <strong>Commande préparée</strong>
                                <p>Votre colis a été emballé et est prêt pour l'expédition.</p>
                            </div>
                        </div>
                        
                        <div class="timeline-step <?php echo strtolower($colis['statut']) !== 'en attente' ? 'completed' : 'active'; ?>">
                            <div class="timeline-icon"></div>
                            <div class="timeline-date"><?= date('d M Y') ?></div>
                            <div class="timeline-content">
                                <strong>Colis <?= strtolower($colis['statut']) === 'en attente' ? 'prêt pour' : htmlspecialchars($colis['statut']); ?></strong>
                                <p>
                                    <?php 
                                        if (strtolower($colis['statut']) === 'livré') {
                                            echo 'Votre colis a été livré avec succès.';
                                        } elseif (strtolower($colis['statut']) === 'expédié') {
                                            echo 'Votre colis est en cours de livraison.';
                                        } else {
                                            echo 'En attente de prise en charge par le transporteur.';
                                        }
                                    ?>
                                </p>
                            </div>
                        </div>
                        
                        <?php if (strtolower($colis['statut']) === 'livré'): ?>
                        <div class="timeline-step completed">
                            <div class="timeline-icon"></div>
                            <div class="timeline-date"><?= date('d M Y') ?></div>
                            <div class="timeline-content">
                                <strong>Livré avec succès</strong>
                                <p>Le colis a été remis au destinataire.</p>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </section>
        
        <footer class="footer">
            <p>© 2025 My Delivery - Tous droits réservés - Powered By: Maroc4web.com</p>
        </footer>
    </div>
</body>
</html>