<?php
session_start();
require 'db.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "يجب تسجيل الدخول أولاً";
    header('Location: login.php');
    exit();
}

// دالة إنشاء رقم عشوائي للطرد
function genererNumeroColis() {
    $prefix = 'ML';
    $date = date('Ymd');
    $random = strtoupper(substr(md5(uniqid(rand(), true)), 0, 6));
    return $prefix . $date . $random;
}

// جلب المدن من قاعدة البيانات
try {
    $stmt = $pdo->query("SELECT nom_ville, frais_livraison FROM villes ORDER BY nom_ville");
    $villes_db = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $villes_maroc = [];
    foreach ($villes_db as $ville) {
        $villes_maroc[$ville['nom_ville']] = $ville['frais_livraison'];
    }
} catch (PDOException $e) {
    die("Erreur de base de données: " . $e->getMessage());
}

// جلب الأسعار التفضيلية للعميل إذا وجدت
$client_prices = [];
try {
    $stmt = $pdo->prepare("SELECT ville, prix FROM client_prices WHERE client_id = ?");
    $stmt->execute([$_SESSION['user']['id']]);
    $client_prices_db = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($client_prices_db as $price) {
        $client_prices[$price['ville']] = $price['prix'];
    }
} catch (PDOException $e) {
    // لا نوقف التحميل إذا كان هناك خطأ في جلب الأسعار التفضيلية
    error_log("Erreur lors de la récupération des prix clients: " . $e->getMessage());
}

// معالجة إرسال النموذج
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_POST['nom']) && !empty($_POST['prenom']) && !empty($_POST['ville']) &&
        !empty($_POST['telephone']) && !empty($_POST['adresse']) && !empty($_POST['montant']) &&
        isset($_POST['autoriser_ouverture'])) {

        // إنشاء رقم الطرد التلقائي
        $numeroColis = genererNumeroColis();
        
        $stmt = $pdo->prepare("INSERT INTO colis 
            (num_colis, nom, prenom, ville, telephone, adresse, montant, statut, user_id, autoriser_ouverture, commentaire) 
            VALUES (?, ?, ?, ?, ?, ?, ?, 'en attente', ?, ?, ?)");

        $stmt->execute([
            $numeroColis,
            $_POST['nom'],
            $_POST['prenom'],
            $_POST['ville'],
            $_POST['telephone'],
            $_POST['adresse'],
            $_POST['montant'],
            $_SESSION['user']['id'],
            $_POST['autoriser_ouverture'] == 'oui' ? 1 : 0,
            $_POST['commentaire'] ?? null
        ]);

        header("Location: liste_colis.php");
        exit();
    } else {
        $erreur = "Veuillez remplir tous les champs obligatoires.";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ajouter un Colis - Plateforme Client</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
            color: var(--dark-color);
        }
        
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background: white;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            padding: 20px 0;
        }
        
        .sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        
        .sidebar-logo {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--primary-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
        }
        
        .sidebar-menu li a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #555;
            text-decoration: none;
            transition: all 0.3s ease;
            gap: 10px;
        }
        
        .sidebar-menu li a:hover, 
        .sidebar-menu li a.active {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            border-left: 3px solid var(--primary-color);
        }
        
        .sidebar-menu li a i {
            width: 20px;
            text-align: center;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
            background: #f5f7fa;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .page-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: var(--dark-color);
        }
        
        .form-container {
            background: white;
            padding: 30px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            max-width: 800px;
            margin: 0 auto;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--dark-color);
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        textarea.form-control {
            min-height: 100px;
            resize: vertical;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }
        
        .form-text {
            font-size: 0.8rem;
            color: #777;
            margin-top: 5px;
        }
        
        .error-message {
            color: var(--error-color);
            font-size: 0.9rem;
            margin-top: 5px;
        }
        
        .btn {
            padding: 12px 20px;
            border: none;
            border-radius: var(--border-radius);
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: var(--primary-color);
            color: white;
        }
        
        .btn-primary:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-group {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }
        
        .delivery-price {
            margin-top: 10px;
            padding: 8px 12px;
            background-color: rgba(75, 181, 67, 0.1);
            color: var(--success-color);
            border-radius: var(--border-radius);
            font-weight: 500;
            display: none;
        }
        
        .radio-group {
            display: flex;
            gap: 15px;
            margin-top: 10px;
        }
        
        .radio-option {
            display: flex;
            align-items: center;
            gap: 5px;
            cursor: pointer;
        }
        
        .radio-option input {
            margin: 0;
            cursor: pointer;
        }
        
        @media (max-width: 992px) {
            .dashboard-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
                height: auto;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- القائمة الجانبية -->
        <div class="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <i class="fas fa-box-open"></i>
                    <span>My Delivery</span>
                </div>
            </div>
            <ul class="sidebar-menu">
                <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Tableau de board</a></li>
                <li><a href="liste_colis.php"><i class="fas fa-boxes"></i> Liste Colis</a></li>
                <li><a href="ajouter_colis.php" class="active"><i class="fas fa-plus-circle"></i> Ajouter un colis</a></li>
                <li><a href="profile.php"><i class="fas fa-user"></i> Profil</a></li>
            </ul>
        </div>
        
        <!-- المحتوى الرئيسي -->
        <div class="main-content">
            <div class="page-header">
                <h1 class="page-title"><i class="fas fa-plus-circle"></i> Ajouter un nouveau Colis</h1>
            </div>
            
            <div class="form-container">
                <?php if (!empty($erreur)): ?>
                    <div class="error-message" style="
                        background: rgba(255, 51, 51, 0.1);
                        padding: 15px;
                        border-radius: var(--border-radius);
                        border-left: 4px solid var(--error-color);
                        margin-bottom: 20px;
                        display: flex;
                        align-items: center;
                        gap: 10px;
                    ">
                        <i class="fas fa-exclamation-circle"></i>
                        <?= $erreur ?>
                    </div>
                <?php endif; ?>
                
                <form method="post">
                    <div class="form-group">
                        <label class="form-label">Numéro de Colis</label>
                        <input type="text" class="form-control" value="<?= isset($numeroColis) ? $numeroColis : 'Généré automatiquement après l\'ajout' ?>" disabled>
                        <small class="form-text">Le numéro sera généré automatiquement</small>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Nom <span style="color: red;">*</span></label>
                        <input type="text" name="nom" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Prénom <span style="color: red;">*</span></label>
                        <input type="text" name="prenom" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Ville <span style="color: red;">*</span></label>
                        <select name="ville" id="ville" class="form-control" required>
                            <option value="">Sélectionnez une ville</option>
                            <?php foreach ($villes_maroc as $ville => $prix): ?>
                                <?php 
                                    // استخدام السعر التفضيلي إذا وجد للعميل، وإلا استخدام السعر الافتراضي
                                    $display_price = isset($client_prices[$ville]) ? $client_prices[$ville] : $prix;
                                ?>
                                <option value="<?= htmlspecialchars($ville) ?>" data-prix="<?= htmlspecialchars($display_price) ?>"><?= htmlspecialchars($ville) ?></option>
                            <?php endforeach; ?>
                        </select>
                        <div id="deliveryPrice" class="delivery-price">
                            Frais de livraison: <span id="priceValue">0</span> DH
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Téléphone <span style="color: red;">*</span></label>
                        <input type="tel" name="telephone" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Adresse <span style="color: red;">*</span></label>
                        <input type="text" name="adresse" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Montant <span style="color: red;">*</span></label>
                        <input type="number" step="0.01" name="montant" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Autorisé d'ouvrir le colis <span style="color: red;">*</span></label>
                        <div class="radio-group">
                            <label class="radio-option">
                                <input type="radio" name="autoriser_ouverture" value="oui" checked> Oui
                            </label>
                            <label class="radio-option">
                                <input type="radio" name="autoriser_ouverture" value="non"> Non
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Commentaire</label>
                        <textarea name="commentaire" class="form-control" rows="3" placeholder="Ajoutez un commentaire optionnel"></textarea>
                        <small class="form-text">Ce champ est facultatif</small>
                    </div>
                    
                    <div class="btn-group">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Ajouter
                        </button>
                        <a href="liste_colis.php" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Retour
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // عرض سعر التوصيل عند اختيار المدينة
        document.getElementById('ville').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const prix = selectedOption.getAttribute('data-prix');
            const deliveryPrice = document.getElementById('deliveryPrice');
            const priceValue = document.getElementById('priceValue');
            
            if (prix) {
                priceValue.textContent = prix;
                deliveryPrice.style.display = 'inline-block';
            } else {
                deliveryPrice.style.display = 'none';
            }
        });
    </script>
</body>
</html>