<?php
session_start();
require 'db.php';

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "يجب تسجيل الدخول أولاً";
    header('Location: login.php');
    exit();
}

// دالة إنشاء رقم عشوائي للطرد
function genererNumeroColis() {
    $prefix = 'ML'; // اختصار لـ Maroc Livraison
    $date = date('Ymd'); // التاريخ الحالي بصيغة YYYYMMDD
    $random = strtoupper(substr(md5(uniqid(rand(), true)), 0, 6)); // 6 أحرف عشوائية
    
    return $prefix . $date . $random;
}

// تنفيذ الإضافة فقط عند الإرسال الحقيقي
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_POST['nom']) && !empty($_POST['prenom']) && !empty($_POST['ville']) &&
        !empty($_POST['telephone']) && !empty($_POST['adresse']) && !empty($_POST['montant'])) {

        // إنشاء رقم الطرد التلقائي
        $numeroColis = genererNumeroColis();
        
        $stmt = $pdo->prepare("INSERT INTO colis 
            (num_colis, nom, prenom, ville, telephone, adresse, montant, statut, user_id) 
            VALUES (?, ?, ?, ?, ?, ?, ?, 'en attente', ?)");

        $stmt->execute([
            $numeroColis,
            $_POST['nom'],
            $_POST['prenom'],
            $_POST['ville'],
            $_POST['telephone'],
            $_POST['adresse'],
            $_POST['montant'],
            $_SESSION['user']['id']
        ]);

        // بعد الإضافة توجه المستخدم للائحة الطرود
        header("Location: liste_colis.php");
        exit();
    } else {
        $erreur = "Veuillez remplir tous les champs.";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Ajouter un Colis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Ajouter un nouveau Colis</h2>
    
    <?php if (!empty($erreur)): ?>
        <div class="alert alert-danger"><?= $erreur ?></div>
    <?php endif; ?>
    
    <form method="post">
        <div class="mb-3">
            <label class="form-label">Numéro de Colis</label>
            <input type="text" class="form-control" value="<?= isset($numeroColis) ? $numeroColis : 'Généré automatiquement après l\'ajout' ?>" disabled>
            <small class="text-muted">Le numéro sera généré automatiquement</small>
        </div>
        
        <?php foreach (['nom', 'prenom', 'ville', 'telephone', 'adresse', 'montant'] as $field): ?>
            <div class="mb-3">
                <label class="form-label"><?= ucfirst($field) ?></label>
                <input type="<?= $field == 'montant' ? 'number' : 'text' ?>" 
                       step="<?= $field == 'montant' ? '0.01' : '' ?>" 
                       name="<?= $field ?>" 
                       class="form-control" 
                       required>
            </div>
        <?php endforeach; ?>
        
        <button type="submit" class="btn btn-primary">Ajouter</button>
        <a href="liste_colis.php" class="btn btn-secondary">Retour</a>
    </form>
</div>
</body>
</html>