<?php
session_start();
require 'db.php';

// التحقق من صلاحية المدير
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    die("Accès refusé. Vous devez être administrateur pour accéder à cette page.");
}

// جلب المستخدمين في انتظار الموافقة
$stmt = $pdo->prepare("SELECT * FROM users WHERE statut = 'en_attente'");
$stmt->execute();
$users = $stmt->fetchAll();


// تحديث صلاحية المستخدم
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user_id']) && isset($_POST['statut'])) {
    $user_id = $_POST['user_id'];
    $statut = $_POST['statut'];

    // تحديث حالة المستخدم (موافقة أو رفض)
    $stmt = $pdo->prepare("UPDATE users SET statut = ? WHERE id = ?");
    $stmt->execute([$statut, $user_id]);

    echo "L'utilisateur a été mis à jour avec succès!";
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Utilisateurs</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Utilisateurs en attente de validation</h2>

    <!-- جدول المستخدمين في انتظار الموافقة -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nom</th>
                <th>Prénom</th>
                <th>Email</th>
                <th>Statut</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($users as $user): ?>
            <tr>
                <td><?= htmlspecialchars($user['id']) ?></td>
                <td><?= htmlspecialchars($user['nom']) ?></td>
                <td><?= htmlspecialchars($user['prenom']) ?></td>
                <td><?= htmlspecialchars($user['email']) ?></td>
                <td><?= htmlspecialchars($user['statut']) ?></td>
                <td>
                    <!-- نموذج لتحديث الصلاحية -->
                    <form method="POST" style="display:inline;">
                        <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                        <select name="statut" class="form-select" onchange="this.form.submit()">
                            <option value="en attente" <?= $user['statut'] == 'en attente' ? 'selected' : '' ?>>En attente</option>
                            <option value="actif" <?= $user['statut'] == 'actif' ? 'selected' : '' ?>>Actif</option>
                            <option value="annulé" <?= $user['statut'] == 'annulé' ? 'selected' : '' ?>>Annulé</option>
                        </select>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
