<?php
// تمكين عرض الأخطاء للتطوير (يجب تعطيلها في الإنتاج)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "يجب تسجيل الدخول أولاً";
    header('Location: login.php');
    exit();
}





if ($_SESSION['user']['role'] !== 'admin') {
    die("Accès refusé: Vous n'avez pas les permissions nécessaires.");
}

require 'db.php';

try {
    // جلب إحصائيات النظام مع معالجة الأخطاء
    $stats = [
        'total_users' => $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn(),
        'active_colis' => $pdo->query("SELECT COUNT(*) FROM colis WHERE statut = 'en attente'")->fetchColumn(),
        'delivered_colis' => $pdo->query("SELECT COUNT(*) FROM colis WHERE statut = 'livré'")->fetchColumn(),
        'total_revenue' => $pdo->query("SELECT IFNULL(SUM(montant), 0) FROM colis")->fetchColumn()
    ];

    // جلب آخر المستخدمين المسجلين
    $recent_users = $pdo->query("SELECT * FROM users ORDER BY id DESC LIMIT 5")->fetchAll();

    // جلب آخر الطرود المضافة
    $recent_colis = $pdo->query("SELECT c.*, u.email FROM colis c JOIN users u ON c.user_id = u.id ORDER BY c.id DESC LIMIT 5")->fetchAll();

} catch (PDOException $e) {
    die("Erreur de base de données: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tableau de Bord Admin - My Delivery</title>
    <!-- بقية كود HTML -->

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <!-- بقية كود HTML كما هو -->

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tableau de Bord Admin - My Delivery</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --error-color: #ff3333;
            --warning-color: #f8d210;
            --admin-color: #6a1b9a;
            --border-radius: 12px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
            color: var(--dark-color);
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        .admin-sidebar {
            width: 280px;
            background: var(--admin-color);
            color: white;
            padding: 20px 0;
        }
        
        .admin-sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            margin-bottom: 20px;
        }
        
        .admin-logo {
            font-size: 1.5rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .admin-logo i {
            font-size: 2rem;
        }
        
        .admin-menu {
            list-style: none;
        }
        
        .admin-menu li a {
            display: flex;
            align-items: center;
            padding: 15px 25px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            transition: all 0.3s ease;
            gap: 12px;
            font-size: 0.95rem;
        }
        
        .admin-menu li a:hover, 
        .admin-menu li a.active {
            background: rgba(255,255,255,0.1);
            color: white;
            border-left: 3px solid white;
        }
        
        .admin-menu li a i {
            width: 20px;
            text-align: center;
            font-size: 1.1rem;
        }
        
        .admin-main {
            flex: 1;
            padding: 30px;
            background: #f5f7fa;
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #eee;
        }
        
        .admin-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: var(--dark-color);
        }
        
        .admin-user {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .admin-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            padding: 25px;
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
        }
        
        .stat-title {
            font-size: 0.9rem;
            color: #777;
            margin-bottom: 10px;
        }
        
        .stat-value {
            font-size: 2rem;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 15px;
            color: var(--admin-color);
            background: rgba(106, 27, 154, 0.1);
        }
        
        .admin-section {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            padding: 25px;
            margin-bottom: 30px;
        }
        
        .section-title {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            color: var(--admin-color);
        }
        
        .section-title i {
            font-size: 1.4rem;
        }
        
        .data-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .data-table th {
            text-align: left;
            padding: 12px 15px;
            background: #f8f9fa;
            font-weight: 500;
            color: #555;
        }
        
        .data-table td {
            padding: 12px 15px;
            border-bottom: 1px solid #eee;
        }
        
        .data-table tr:last-child td {
            border-bottom: none;
        }
        
        .status-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .status-pending {
            background: rgba(248, 210, 16, 0.2);
            color: #b38f00;
        }
        
        .status-delivered {
            background: rgba(75, 181, 67, 0.2);
            color: var(--success-color);
        }
        
        .status-active {
            background: rgba(67, 97, 238, 0.2);
            color: var(--primary-color);
        }
        
        .status-inactive {
            background: rgba(108, 117, 125, 0.2);
            color: #6c757d;
        }
        
        .view-all {
            display: inline-block;
            margin-top: 15px;
            color: var(--admin-color);
            text-decoration: none;
            font-weight: 500;
        }
        
        .view-all:hover {
            text-decoration: underline;
        }
        
        .action-btn {
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 0.8rem;
            text-decoration: none;
            margin-right: 5px;
        }
        
        .edit-btn {
            background: rgba(248, 210, 16, 0.2);
            color: #b38f00;
        }
        
        .edit-btn:hover {
            background: rgba(248, 210, 16, 0.3);
        }
        
        .delete-btn {
            background: rgba(255, 51, 51, 0.2);
            color: var(--error-color);
        }
        
        .delete-btn:hover {
            background: rgba(255, 51, 51, 0.3);
        }
        
        @media (max-width: 992px) {
            .admin-container {
                flex-direction: column;
            }
            
            .admin-sidebar {
                width: 100%;
                height: auto;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <!-- القائمة الجانبية -->
        <div class="admin-sidebar">
            <div class="admin-sidebar-header">
                <div class="admin-logo">
                    <i class="fas fa-user-shield"></i>
                    <span>Admin Panel</span>
                </div>
            </div>
            <ul class="admin-menu">
                <li><a href="admin.php" class="active"><i class="fas fa-tachometer-alt"></i> Tableau de Bord</a></li>
                <li><a href="admin_users.php"><i class="fas fa-users"></i> Gestion Utilisateurs</a></li>
                <li><a href="admin_colis.php"><i class="fas fa-boxes"></i> Gestion Colis</a></li>
                <li><a href="admin_villes.php"><i class="fas fa-city"></i> Gestion Villes & Tarifs</a></li>
                <li><a href="admin_reclamations.php"><i class="fas fa-headset"></i> Réclamations</a></li>
                <li><a href="admin_settings.php"><i class="fas fa-cog"></i> Paramètres</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Déconnexion</a></li>
            </ul>
        </div>
        
        <!-- المحتوى الرئيسي -->
        <div class="admin-main">
            <div class="admin-header">
                <h1 class="admin-title"><i class="fas fa-tachometer-alt"></i> Tableau de Bord Admin</h1>
                <div class="admin-user">
                    <div class="admin-avatar">
                        <?= substr($_SESSION['user']['nom'] ?? 'A', 0, 1) ?>
                    </div>
                    <span><?= $_SESSION['user']['nom'] ?? 'Admin' ?></span>
                </div>
            </div>
            
            <!-- بطاقات الإحصائيات -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-title">Utilisateurs Inscrits</div>
                    <div class="stat-value"><?= $stats['total_users'] ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-box-open"></i>
                    </div>
                    <div class="stat-title">Colis en Attente</div>
                    <div class="stat-value"><?= $stats['active_colis'] ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="stat-title">Colis Livrés</div>
                    <div class="stat-value"><?= $stats['delivered_colis'] ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="stat-title">Revenu Total</div>
                    <div class="stat-value"><?= number_format($stats['total_revenue'], 2) ?> DH</div>
                </div>
            </div>
            
            <!-- آخر المستخدمين المسجلين -->
            <div class="admin-section">
                <h3 class="section-title">
                    <i class="fas fa-user-clock"></i> Derniers Utilisateurs Inscrits
                </h3>
                
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nom</th>
                            <th>Email</th>
                            <th>Rôle</th>
                            <th>Statut</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($recent_users as $user): ?>
                        <tr>
                            <td><?= $user['id'] ?></td>
                            <td><?= htmlspecialchars($user['nom']) ?></td>
                            <td><?= htmlspecialchars($user['email']) ?></td>
                            <td><?= ucfirst($user['role']) ?></td>
                            <td>
                                <span class="status-badge <?= $user['statut'] == 'actif' ? 'status-active' : 'status-inactive' ?>">
                                    <?= ucfirst($user['statut']) ?>
                                </span>
                            </td>
                            <td>
                                <a href="admin_edit_user.php?id=<?= $user['id'] ?>" class="action-btn edit-btn">
                                    <i class="fas fa-edit"></i> Modifier
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
                <a href="admin_users.php" class="view-all">
                    <i class="fas fa-list"></i> Voir tous les utilisateurs
                </a>
            </div>
            
            <!-- آخر الطرود المضافة -->
            <div class="admin-section">
                <h3 class="section-title">
                    <i class="fas fa-boxes"></i> Derniers Colis Ajoutés
                </h3>
                
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Numéro</th>
                            <th>Client</th>
                            <th>Ville</th>
                            <th>Montant</th>
                            <th>Statut</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($recent_colis as $colis): ?>
                        <tr>
                            <td><?= $colis['id'] ?></td>
                            <td><?= $colis['num_colis'] ?? '-' ?></td>
                            <td><?= htmlspecialchars($colis['email']) ?></td>
                            <td><?= htmlspecialchars($colis['ville']) ?></td>
                            <td><?= htmlspecialchars($colis['montant']) ?> DH</td>
                            <td>
                                <span class="status-badge status-<?= str_replace(' ', '-', strtolower($colis['statut'])) ?>">
                                    <?= htmlspecialchars($colis['statut']) ?>
                                </span>
                            </td>
                            <td>
                                <a href="admin_edit_colis.php?id=<?= $colis['id'] ?>" class="action-btn edit-btn">
                                    <i class="fas fa-edit"></i> Modifier
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
                <a href="admin_colis.php" class="view-all">
                    <i class="fas fa-list"></i> Voir tous les colis
                </a>
            </div>
        </div>
    </div>
</body>
</html>