<?php
// تمكين عرض الأخطاء للتطوير
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// التحقق من تسجيل الدخول والصلاحيات
if (!isset($_SESSION['user']['id']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit();
}

require 'db.php';

// التحقق من وجود معرف السعر في البيانات المرسلة
if (!isset($_POST['id']) || !is_numeric($_POST['id'])) {
    $_SESSION['error_message'] = "ID de prix client invalide";
    header('Location: remises.php');
    exit();
}

$price_id = (int)$_POST['id'];

try {
    // التحقق من وجود السعر قبل الحذف
    $stmt = $pdo->prepare("SELECT id FROM client_prices WHERE id = ?");
    $stmt->execute([$price_id]);
    $price = $stmt->fetch();

    if (!$price) {
        $_SESSION['error_message'] = "Prix client non trouvé";
        header('Location: remises.php');
        exit();
    }

    // حذف السعر
    $delete_stmt = $pdo->prepare("DELETE FROM client_prices WHERE id = ?");
    $delete_stmt->execute([$price_id]);

    $_SESSION['success_message'] = "Prix client supprimé avec succès";
    header('Location: remises.php');
    exit();

} catch (PDOException $e) {
    $_SESSION['error_message'] = "Erreur lors de la suppression: " . $e->getMessage();
    header('Location: remises.php');
    exit();
}
?>