<?php
session_start();
require 'db.php';

// Vérification de la connexion et du rôle admin
if (!isset($_SESSION['user']['id'])) {
    $_SESSION['login_error'] = "Vous devez vous connecter d'abord";
    header('Location: login.php');
    exit();
}

if ($_SESSION['user']['role'] !== 'admin') {
    $_SESSION['access_error'] = "Accès refusé - Vous n'avez pas les permissions nécessaires";
    header('Location: index.php');
    exit();
}

// Traitement de la suppression multiple
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_selected'])) {
    if (!empty($_POST['selected_colis'])) {
        $selected_colis = $_POST['selected_colis'];
        $placeholders = implode(',', array_fill(0, count($selected_colis), '?'));
        
        $sql_delete = "DELETE FROM colis WHERE id IN ($placeholders)";
        $stmt_delete = $pdo->prepare($sql_delete);
        $stmt_delete->execute($selected_colis);
        
        $_SESSION['success_message'] = count($selected_colis) . " colis supprimés avec succès";
    } else {
        $_SESSION['error_message'] = "Aucun colis sélectionné pour la suppression";
    }
    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Traitement de la suppression du colis
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['delete_id'])) {
    $colis_id = $_GET['delete_id'];
    
    $sql_delete = "DELETE FROM colis WHERE id = ?";
    $stmt_delete = $pdo->prepare($sql_delete);
    $stmt_delete->execute([$colis_id]);
    
    $_SESSION['success_message'] = "Colis supprimé avec succès";
    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Traitement du changement de statut de règlement
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['changer_reglement'])) {
    $colis_id = $_POST['colis_id'];
    $nouveau_reglement = $_POST['reglement'];
    
    $sql_update = "UPDATE colis SET reglement = ? WHERE id = ?";
    $stmt_update = $pdo->prepare($sql_update);
    $stmt_update->execute([$nouveau_reglement, $colis_id]);
    
    $_SESSION['success_message'] = "Statut de règlement mis à jour avec succès";
    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Application des filtres
$recherche = $_GET['recherche'] ?? '';
$filtre = $_GET['filtre'] ?? '';
$ville_filtre = $_GET['ville'] ?? '';
$reglement_filtre = $_GET['reglement'] ?? '';

// Pagination
$par_page = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$debut = ($page - 1) * $par_page;

// Construction de la requête SQL
$sql = "SELECT * FROM colis WHERE 1=1";
$params = [];

if (!empty($recherche)) {
    $sql .= " AND (nom LIKE ? OR prenom LIKE ? OR telephone LIKE ? OR num_colis LIKE ?)";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
    $params[] = "%$recherche%";
}

if (!empty($filtre)) {
    $sql .= " AND statut = ?";
    $params[] = $filtre;
}

if (!empty($ville_filtre)) {
    $sql .= " AND ville = ?";
    $params[] = $ville_filtre;
}

if (!empty($reglement_filtre)) {
    $sql .= " AND reglement = ?";
    $params[] = $reglement_filtre;
}

$sql .= " ORDER BY id DESC LIMIT $debut, $par_page";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$colis = $stmt->fetchAll();

// Récupérer la liste des villes distinctes pour le filtre
$villes = $pdo->query("SELECT DISTINCT ville FROM colis ORDER BY ville")->fetchAll();

// Compter le nombre total de colis pour la pagination
$sql_count = "SELECT COUNT(*) FROM colis WHERE 1=1";
$params_count = [];

if (!empty($recherche)) {
    $sql_count .= " AND (nom LIKE ? OR prenom LIKE ? OR telephone LIKE ? OR num_colis LIKE ?)";
    $params_count[] = "%$recherche%";
    $params_count[] = "%$recherche%";
    $params_count[] = "%$recherche%";
    $params_count[] = "%$recherche%";
}

if (!empty($filtre)) {
    $sql_count .= " AND statut = ?";
    $params_count[] = $filtre;
}

if (!empty($ville_filtre)) {
    $sql_count .= " AND ville = ?";
    $params_count[] = $ville_filtre;
}

if (!empty($reglement_filtre)) {
    $sql_count .= " AND reglement = ?";
    $params_count[] = $reglement_filtre;
}

$stmt_count = $pdo->prepare($sql_count);
$stmt_count->execute($params_count);
$total_colis = $stmt_count->fetchColumn();

// Calcul du nombre total de pages
$total_pages = ceil($total_colis / $par_page);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestion des Colis - Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #6a1b9a;
            --primary-light: #9c4dcc;
            --primary-dark: #38006b;
            --secondary-color: #f3e5f5;
            --text-color: #212121;
            --light-text: #f5f5f5;
            --background: #f5f5f5;
            --card-bg: #ffffff;
            --success-color: #4caf50;
            --warning-color: #ff9800;
            --error-color: #f44336;
            --info-color: #2196F3;
            --border-radius: 8px;
            --box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            background-color: var(--background);
            color: var(--text-color);
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }

        .sidebar {
            width: 280px;
            background: linear-gradient(to bottom, var(--primary-dark), var(--primary-color));
            color: var(--light-text);
            padding: 20px 0;
            transition: all 0.3s;
        }

        .sidebar-header {
            padding: 0 20px 30px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .sidebar-logo {
            font-size: 1.5rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
            color: white;
        }

        .sidebar-menu {
            list-style: none;
            margin-top: 20px;
        }

        .sidebar-menu li a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            transition: all 0.3s;
            gap: 12px;
            font-size: 0.95rem;
            border-left: 4px solid transparent;
        }

        .sidebar-menu li a:hover, 
        .sidebar-menu li a.active {
            background: rgba(255,255,255,0.1);
            color: white;
            border-left: 4px solid var(--primary-light);
        }

        .sidebar-menu li a i {
            width: 20px;
            text-align: center;
            font-size: 1.1rem;
        }

        .main-content {
            flex: 1;
            padding: 30px;
            background-color: var(--background);
        }

        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }

        .page-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: var(--primary-dark);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-filter-container {
            background: var(--card-bg);
            padding: 20px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 30px;
        }

        .search-form {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
            align-items: center;
        }

        .search-input {
            flex: 1;
            min-width: 250px;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: all 0.3s;
        }

        .search-input:focus {
            border-color: var(--primary-light);
            outline: none;
            box-shadow: 0 0 0 2px rgba(106,27,154,0.2);
        }

        .filter-select {
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 1rem;
            min-width: 200px;
            background-color: white;
            cursor: pointer;
        }

        .filter-select:focus {
            border-color: var(--primary-light);
            outline: none;
        }

        .search-btn {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: var(--border-radius);
            cursor: pointer;
            transition: all 0.3s;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .search-btn:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .colis-table-container {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            margin-bottom: 30px;
        }

        .colis-table {
            width: 100%;
            border-collapse: collapse;
        }

        .colis-table th {
            background: var(--primary-color);
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 500;
        }

        .colis-table td {
            padding: 12px 15px;
            border-bottom: 1px solid rgba(0,0,0,0.05);
        }

        .colis-table tr:last-child td {
            border-bottom: none;
        }

        .colis-table tr:hover td {
            background: rgba(106,27,154,0.03);
        }

        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
            display: inline-block;
        }

        .status-en-attente {
            background: rgba(255,152,0,0.1);
            color: var(--warning-color);
        }

        .status-en-cours {
            background: rgba(106,27,154,0.1);
            color: var(--primary-color);
        }

        .status-livre {
            background: rgba(76,175,80,0.1);
            color: var(--success-color);
        }

        .status-annule {
            background: rgba(244,67,54,0.1);
            color: var(--error-color);
        }

        .reglement-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
            display: inline-block;
        }

        .reglement-paye {
            background: rgba(76,175,80,0.1);
            color: var(--success-color);
        }

        .reglement-en-cours {
            background: rgba(33,150,243,0.1);
            color: var(--info-color);
        }

        .reglement-form {
            display: inline-block;
            margin-left: 5px;
        }

        .reglement-select {
            padding: 4px 8px;
            border-radius: var(--border-radius);
            border: 1px solid #ddd;
            font-size: 0.85rem;
            background-color: white;
        }

        .reglement-submit {
            padding: 4px 8px;
            border-radius: var(--border-radius);
            border: none;
            background: var(--primary-color);
            color: white;
            cursor: pointer;
            font-size: 0.85rem;
            margin-left: 5px;
        }

        .reglement-submit:hover {
            background: var(--primary-dark);
        }

        .action-btn {
            padding: 6px 10px;
            border-radius: 4px;
            font-size: 0.85rem;
            text-decoration: none;
            margin-right: 5px;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: all 0.2s;
        }

        .edit-btn {
            background: rgba(255,152,0,0.1);
            color: var(--warning-color);
        }

        .edit-btn:hover {
            background: rgba(255,152,0,0.2);
        }

        .delete-btn {
            background: rgba(244,67,54,0.1);
            color: var(--error-color);
        }

        .delete-btn:hover {
            background: rgba(244,67,54,0.2);
        }

        .add-btn {
            background: var(--primary-color);
            color: white;
            padding: 12px 20px;
            border-radius: var(--border-radius);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            font-weight: 500;
            transition: all 0.3s;
        }

        .add-btn:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .no-data {
            text-align: center;
            padding: 40px;
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
        }

        .no-data i {
            font-size: 3rem;
            color: #ddd;
            margin-bottom: 15px;
        }

        .no-data h3 {
            font-size: 1.5rem;
            margin-bottom: 10px;
            color: var(--text-color);
        }

        .no-data p {
            color: #777;
        }

        .pagination {
            display: flex;
            justify-content: center;
            gap: 8px;
            margin-top: 30px;
            flex-wrap: wrap;
        }

        .pagination a, .pagination span {
            padding: 8px 16px;
            border-radius: var(--border-radius);
            text-decoration: none;
            color: var(--primary-color);
            border: 1px solid #ddd;
            transition: all 0.3s;
            font-size: 0.9rem;
        }

        .pagination a:hover {
            background: rgba(106,27,154,0.1);
            border-color: var(--primary-light);
        }

        .pagination .active {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }

        .pagination-info {
            text-align: center;
            margin-top: 15px;
            color: #666;
            font-size: 0.9rem;
        }

        .success-message {
            background: rgba(76,175,80,0.1);
            color: var(--success-color);
            padding: 15px;
            border-radius: var(--border-radius);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .error-message {
            background: rgba(244,67,54,0.1);
            color: var(--error-color);
            padding: 15px;
            border-radius: var(--border-radius);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .select-all-container {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 15px;
        }

        .select-all-checkbox {
            width: 16px;
            height: 16px;
            cursor: pointer;
        }

        .delete-selected-btn {
            background: var(--error-color);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: var(--border-radius);
            cursor: pointer;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s;
        }

        .delete-selected-btn:hover {
            background: #d32f2f;
            transform: translateY(-2px);
        }

        .colis-checkbox {
            width: 16px;
            height: 16px;
            cursor: pointer;
        }

        @media (max-width: 992px) {
            .dashboard-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
                padding: 15px;
            }
            
            .sidebar-menu {
                display: flex;
                overflow-x: auto;
                padding-bottom: 10px;
            }
            
            .sidebar-menu li {
                flex-shrink: 0;
            }
            
            .sidebar-menu li a {
                border-left: none;
                border-bottom: 3px solid transparent;
                padding: 10px 15px;
            }
            
            .sidebar-menu li a.active,
            .sidebar-menu li a:hover {
                border-left: none;
                border-bottom: 3px solid var(--primary-light);
            }
            
            .search-form {
                flex-direction: column;
                align-items: stretch;
            }
            
            .search-input, .filter-select {
                width: 100%;
            }
            
            .colis-table td, .colis-table th {
                padding: 8px 10px;
                font-size: 0.9rem;
            }
            
            .reglement-form {
                display: block;
                margin-top: 5px;
                margin-left: 0;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- Menu latéral -->
        <div class="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Tableau de Bord</span>
                </div>
            </div>
            <ul class="sidebar-menu">
                  <li><a href="index.php"> <i class="fas fa-tachometer-alt"></i> Tableau de Bord</a></li>
                <li><a href="admin_users.php"><i class="fas fa-users"></i> Gestion Utilisateurs</a></li>
                <li><a href="admin_colis.php" class="active"><i class="fas fa-boxes"></i> Gestion Colis</a></li>
                <li><a href="admin_villes.php"><i class="fas fa-city"></i> Gestion Villes & Tarifs</a></li>
                <li><a href="admin_commissions.php"><i class="fas fa-money-bill-wave"></i> Commissions Livreurs</a></li>
                <li><a href="remises.php"><i class="fas fa-tag"></i> Remise Clients</a></li>
               
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Déconnexion</a></li>

            </ul>
        </div>

        <!-- Contenu principal -->
        <div class="main-content">
            <?php if (isset($_SESSION['success_message'])): ?>
                <div class="success-message">
                    <i class="fas fa-check-circle"></i>
                    <?= $_SESSION['success_message'] ?>
                </div>
                <?php unset($_SESSION['success_message']); ?>
            <?php endif; ?>
            
            <?php if (isset($_SESSION['error_message'])): ?>
                <div class="error-message">
                    <i class="fas fa-exclamation-circle"></i>
                    <?= $_SESSION['error_message'] ?>
                </div>
                <?php unset($_SESSION['error_message']); ?>
            <?php endif; ?>
            
            <div class="page-header">
                <h1 class="page-title"><i class="fas fa-boxes"></i> Gestion des Colis</h1>
                <a href="ajouter_colis.php" class="add-btn">
                    <i class="fas fa-plus"></i> Ajouter un Colis
                </a>
            </div>

            <!-- Filtres de recherche -->
            <div class="search-filter-container">
                <form method="get" class="search-form">
                    <input type="text" name="recherche" class="search-input" placeholder="Rechercher par nom, téléphone ou numéro..." value="<?= htmlspecialchars($recherche) ?>">
                    
                    <select name="ville" class="filter-select">
                        <option value="">-- Toutes les villes --</option>
                        <?php foreach ($villes as $ville): ?>
                            <option value="<?= htmlspecialchars($ville['ville']) ?>" <?= $ville_filtre === $ville['ville'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($ville['ville']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    
                    <select name="filtre" class="filter-select">
                        <option value="">-- Tous les statuts --</option>
                        <?php foreach (['en attente', 'en cours', 'livré', 'annulé'] as $statut_option): ?>
                            <option value="<?= $statut_option ?>" <?= $filtre === $statut_option ? 'selected' : '' ?>><?= ucfirst($statut_option) ?></option>
                        <?php endforeach; ?>
                    </select>
                    
                    <select name="reglement" class="filter-select">
                        <option value="">-- Tous les règlements --</option>
                        <option value="payé" <?= $reglement_filtre === 'payé' ? 'selected' : '' ?>>Payé</option>
                        <option value="en cours" <?= $reglement_filtre === 'en cours' ? 'selected' : '' ?>>En cours</option>
                    </select>
                    
                    <button type="submit" class="search-btn">
                        <i class="fas fa-search"></i> Filtrer
                    </button>
                </form>
            </div>

            <!-- Liste des colis -->
            <?php if (!empty($colis)): ?>
            <form method="post" id="delete-selected-form">
                <div class="select-all-container">
                    <input type="checkbox" id="select-all" class="select-all-checkbox">
                    <label for="select-all">Sélectionner tous</label>
                    <button type="submit" name="delete_selected" class="delete-selected-btn" onclick="return confirm('Êtes-vous sûr de vouloir supprimer les colis sélectionnés?')">
                        <i class="fas fa-trash"></i> Supprimer les sélectionnés
                    </button>
                </div>
                
                <div class="colis-table-container">
                    <table class="colis-table">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Numéro</th>
                                <th>Nom</th>
                                <th>Ville</th>
                                <th>Téléphone</th>
                                <th>Montant</th>
                                <th>Statut</th>
                                <th>Règlement</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($colis as $colisItem): ?>
                            <tr>
                                <td><input type="checkbox" name="selected_colis[]" value="<?= $colisItem['id'] ?>" class="colis-checkbox"></td>
                                <td><?= htmlspecialchars($colisItem['num_colis']) ?></td>
                                <td><?= htmlspecialchars($colisItem['nom']) ?></td>
                                <td><?= htmlspecialchars($colisItem['ville']) ?></td>
                                <td><?= htmlspecialchars($colisItem['telephone']) ?></td>
                                <td><?= htmlspecialchars($colisItem['montant']) ?> DH</td>
                                <td>
                                    <span class="status-badge status-<?= str_replace(' ', '-', strtolower($colisItem['statut'])) ?>">
                                        <?= htmlspecialchars($colisItem['statut']) ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="reglement-badge reglement-<?= str_replace(' ', '-', strtolower($colisItem['reglement'] ?? 'en cours')) ?>">
                                        <?= htmlspecialchars($colisItem['reglement'] ?? 'en cours') ?>
                                    </span>
                                    <form method="post" class="reglement-form">
                                        <input type="hidden" name="colis_id" value="<?= $colisItem['id'] ?>">
                                        <select name="reglement" class="reglement-select">
                                            <option value="payé" <?= ($colisItem['reglement'] ?? 'en cours') === 'payé' ? 'selected' : '' ?>>Payé</option>
                                            <option value="en cours" <?= ($colisItem['reglement'] ?? 'en cours') === 'en cours' ? 'selected' : '' ?>>En cours</option>
                                        </select>
                                        <button type="submit" name="changer_reglement" class="reglement-submit">
                                            <i class="fas fa-sync-alt"></i>
                                        </button>
                                    </form>
                                </td>
                                <td>
                                    <a href="modifier_colis.php?id=<?= $colisItem['id'] ?>" class="action-btn edit-btn" title="Modifier">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="admin_colis.php?delete_id=<?= $colisItem['id'] ?>" class="action-btn delete-btn" title="Supprimer" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce colis?')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </form>

            <!-- Pagination -->
            <div class="pagination-info">
                Affichage de <?= $debut + 1 ?> à <?= min($debut + $par_page, $total_colis) ?> sur <?= $total_colis ?> colis
            </div>
            
            <div class="pagination">
                <?php if ($page > 1): ?>
                    <a href="?<?= http_build_query(array_merge($_GET, ['page' => 1])) ?>" title="Première page">
                        <i class="fas fa-angle-double-left"></i>
                    </a>
                    <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page - 1])) ?>" title="Page précédente">
                        <i class="fas fa-angle-left"></i>
                    </a>
                <?php endif; ?>

                <?php 
                $start_page = max(1, $page - 2);
                $end_page = min($total_pages, $page + 2);
                
                if ($start_page > 1) echo '<span>...</span>';
                
                for ($i = $start_page; $i <= $end_page; $i++): ?>
                    <a href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>" class="<?= $i == $page ? 'active' : '' ?>">
                        <?= $i ?>
                    </a>
                <?php endfor; 
                
                if ($end_page < $total_pages) echo '<span>...</span>';
                ?>

                <?php if ($page < $total_pages): ?>
                    <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page + 1])) ?>" title="Page suivante">
                        <i class="fas fa-angle-right"></i>
                    </a>
                    <a href="?<?= http_build_query(array_merge($_GET, ['page' => $total_pages])) ?>" title="Dernière page">
                        <i class="fas fa-angle-double-right"></i>
                    </a>
                <?php endif; ?>
            </div>
            <?php else: ?>
                <div class="no-data">
                    <i class="fas fa-box-open"></i>
                    <h3>Aucun colis trouvé</h3>
                    <p>Aucun colis ne correspond à vos critères de recherche.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        // Sélectionner/désélectionner tous les colis
        document.getElementById('select-all').addEventListener('change', function() {
            const checkboxes = document.querySelectorAll('.colis-checkbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
        });

        // Désélectionner "Sélectionner tous" si un colis est désélectionné
        const checkboxes = document.querySelectorAll('.colis-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                if (!this.checked) {
                    document.getElementById('select-all').checked = false;
                } else {
                    // Vérifier si tous les colis sont sélectionnés
                    const allChecked = Array.from(checkboxes).every(cb => cb.checked);
                    document.getElementById('select-all').checked = allChecked;
                }
            });
        });
    </script>
</body>
</html>