<?php
// Activation du rapport d'erreurs
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Connexion à la base de données
require_once 'config.php';

try {
    $stmt = $pdo->query("SELECT * FROM colis ORDER BY date_creation DESC");
    $colis = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erreur de base de données: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Liste des Colis - DZONEXPRESS</title>
    <style>
        /* Reset CSS */
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; background: #f5f5f5; }
        
        /* Layout */
        .container { display: flex; min-height: 100vh; }
        .sidebar { 
            width: 250px; 
            background: #2c3e50; 
            color: white;
            padding: 20px;
            position: fixed;
            height: 100%;
        }
        .content { 
            margin-left: 250px;
            padding: 20px;
            flex: 1;
            background: white;
        }
        
        /* Menu */
        .sidebar ul { list-style: none; }
        .sidebar li { margin-bottom: 15px; }
        .sidebar a { 
            color: #ecf0f1; 
            text-decoration: none;
            display: block;
            padding: 5px 0;
        }
        .sidebar .active { color: white; font-weight: bold; }
        
        /* Table */
        .colis-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .colis-table th, .colis-table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        .colis-table th {
            background: #2c3e50;
            color: white;
        }
        .colis-table tr:nth-child(even) {
            background: #f9f9f9;
        }
        
        /* Windows Notice */
        .windows-notice {
            margin-top: 30px;
            padding: 15px;
            background: #f8f9fa;
            border-left: 4px solid #ffc107;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Menu latéral -->
        <nav class="sidebar">
            <h3>LA MARQUE</h3>
            <ul>
                <li>
                    <span>Accueil</span>
                    <ul>
                        <li><a href="index.php">Colis</a></li>
                        <li><a href="index.php">Nouveau Colis</a></li>
                        <li><a href="list.php" class="active">List Colis</a></li>
                        <li><a href="#">Colis pour ramassage</a></li>
                        <li><a href="#">Import Colis</a></li>
                    </ul>
                </li>
                <li>
                    <span>Bons de livraison</span>
                    <ul>
                        <li><a href="#">Bon de retour</a></li>
                        <li><a href="#">Bon de retour (New)</a></li>
                        <li><a href="#">Liste Factures</a></li>
                    </ul>
                </li>
            </ul>
        </nav>

        <!-- Contenu principal -->
        <main class="content">
            <h2>Liste des Colis</h2>
            
            <?php if (!empty($colis)): ?>
                <table class="colis-table">
                    <thead>
                        <tr>
                            <th>Code Suivi</th>
                            <th>Destinataire</th>
                            <th>Téléphone</th>
                            <th>Ville</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($colis as $col): ?>
                        <tr>
                            <td><?= htmlspecialchars($col['code_suivi']) ?></td>
                            <td><?= htmlspecialchars($col['destinataire']) ?></td>
                            <td><?= htmlspecialchars($col['telephone']) ?></td>
                            <td><?= htmlspecialchars($col['ville']) ?></td>
                            <td><?= date('d/m/Y H:i', strtotime($col['date_creation'])) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>Aucun colis trouvé.</p>
            <?php endif; ?>

            <div class="windows-notice">
                <p>Activer Windows</p>
                <p>Accédez aux paramètres pour activer Windows.</p>
            </div>
        </main>
    </div>
</body>
</html>