<?php
// Démarrage de session et connexion DB
session_start();
require_once 'config.php';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DZONEXPRESS - MON STOP DELIVERY</title>
    <style>
    <?php include 'style.css'; ?>
    </style>
</head>
<body>
    <div class="container">
        <nav class="sidebar">
            <h3>LA MARQUE</h3>
            <ul>
                <li class="menu-item">
                    <span>Accueil</span>
                    <ul class="submenu">
                        <li><a href="index.php">Colis</a></li>
                        <li><a href="index.php">Nouveau Colis</a></li>
                        <li><a href="list.php">List Colis</a></li>
                        <li><a href="#">Colis pour ramassage</a></li>
                        <li><a href="#">Import Colis</a></li>
                    </ul>
                </li>
                <li class="menu-item">
                    <span>Bons de livraison</span>
                    <ul class="submenu">
                        <li><a href="#">Bon de retour</a></li>
                    </ul>
                </li>
                <li><a href="#">Bon de retour ( New )</a></li>
                <li><a href="#">Liste Factures</a></li>
            </ul>
        </nav>

        <main class="content">
            <form action="process.php" method="post">
                <!-- Première colonne -->
                <div class="form-column">
                    <div class="form-section">
                        <label>Code suivi *</label>
                        <input type="text" name="code_suivi" required>
                    </div>
                    
                    <div class="form-section">
                        <label>Ville *</label>
                        <input type="text" name="ville" required>
                    </div>
                    
                    <div class="form-section">
                        <label>Adresse *</label>
                        <input type="text" name="adresse" required>
                    </div>
                    
                    <div class="form-section">
                        <label>Prix *</label>
                        <input type="number" step="0.01" name="prix" required>
                    </div>
                </div>
                
                <!-- Deuxième colonne -->
                <div class="form-column">
                    <div class="form-section">
                        <label>Destinataire *</label>
                        <input type="text" name="destinataire" required>
                    </div>
                    
                    <div class="form-section">
                        <label>Quartier</label>
                        <input type="text" name="quartier">
                    </div>
                    
                    <div class="form-section">
                        <label>Téléphone *</label>
                        <input type="tel" name="telephone" required>
                    </div>
                    
                    <div class="form-section">
                        <label>Nature du Produit</label>
                        <input type="text" name="nature_produit">
                    </div>
                </div>
                
                <!-- Commentaire sur toute la largeur -->
                <div class="form-full-width">
                    <div class="form-section">
                        <label>Commentaire (Autre téléphone, Date de livraison...)</label>
                        <textarea name="commentaire" rows="3"></textarea>
                    </div>
                </div>
                
                <div class="form-submit">
                    <button type="submit" class="submit-btn">Enregistrer le colis</button>
                </div>
            </form>

            <div class="windows-notice">
                <p>Activer Windows</p>
                <p>Accédez aux paramètres pour activer Windows.</p>
            </div>
        </main>
    </div>

    <script>
        // Script pour le menu déroulant
        document.querySelectorAll('.menu-item > span').forEach(item => {
            item.addEventListener('click', () => {
                const submenu = item.nextElementSibling;
                submenu.style.display = submenu.style.display === 'block' ? 'none' : 'block';
            });
        });
    </script>
</body>
</html>